/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.FileUtils;
import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import java.io.File;
import java.util.Properties;

public final class PatchworkComposerProperties
extends Enum<PatchworkComposerProperties> {
    public static final /* enum */ PatchworkComposerProperties ROUTE_STDERR_TO_LOG = new PatchworkComposerProperties("routeStdErrToLog", "true");
    public static final /* enum */ PatchworkComposerProperties CARD_SIZE = new PatchworkComposerProperties("cardSize", "300");
    public static final /* enum */ PatchworkComposerProperties PROJECT_FILE = new PatchworkComposerProperties("file.project", "PW1.project.xml");
    public static final /* enum */ PatchworkComposerProperties PROJECT_DIR = new PatchworkComposerProperties("file.projectDir", ".");
    public static final /* enum */ PatchworkComposerProperties ART_DIR = new PatchworkComposerProperties("file.artDir", ".");
    public static final /* enum */ PatchworkComposerProperties SAVEGAME_DIR = new PatchworkComposerProperties("file.saveGameDir", ".");
    public static final /* enum */ PatchworkComposerProperties AS3_OUTPUT_DIR = new PatchworkComposerProperties("file.as3OutputDir", ".");
    public static final /* enum */ PatchworkComposerProperties AS3_IMAGE_OUTPUT_DIR = new PatchworkComposerProperties("file.as3ImageOutputDir", ".");
    public static final /* enum */ PatchworkComposerProperties AS3_TEMPLATE_FILE = new PatchworkComposerProperties("file.as3TemplateFile", ".");
    private final String propertyName;
    private final String defaultValue;
    private static final /* synthetic */ PatchworkComposerProperties[] $VALUES;

    public static PatchworkComposerProperties[] values() {
        return (PatchworkComposerProperties[])$VALUES.clone();
    }

    public static PatchworkComposerProperties valueOf(String name) {
        return Enum.valueOf(PatchworkComposerProperties.class, name);
    }

    public String getValue() {
        Properties properties = System.getProperties();
        if (properties.containsKey(this.propertyName)) {
            return properties.getProperty(this.propertyName);
        }
        return this.defaultValue;
    }

    public int getInt() {
        return Integer.valueOf(this.getValue());
    }

    public boolean getBoolean() {
        return Boolean.valueOf(this.getValue());
    }

    public File getFile() {
        return FileUtils.canonicalOrAbsolute(new File(this.getValue()));
    }

    public static File getIODirectory(IOFileType fileType) {
        String propertyName = PatchworkComposerProperties.toFullPropertyName("file." + fileType.name().toLowerCase());
        Properties properties = System.getProperties();
        File result = properties.containsKey(propertyName) ? new File(ART_DIR.getFile(), properties.getProperty(propertyName)) : ART_DIR.getFile();
        return FileUtils.canonicalOrAbsolute(result);
    }

    private PatchworkComposerProperties(String localPropertyName, String defaultValue) {
        assert (localPropertyName != null);
        this.propertyName = PatchworkComposerProperties.toFullPropertyName(localPropertyName);
        this.defaultValue = defaultValue;
    }

    private static String toFullPropertyName(String localPropertyName) {
        return PatchworkComposerProperties.class.getPackage().getName() + "." + localPropertyName;
    }

    static {
        $VALUES = new PatchworkComposerProperties[]{ROUTE_STDERR_TO_LOG, CARD_SIZE, PROJECT_FILE, PROJECT_DIR, ART_DIR, SAVEGAME_DIR, AS3_OUTPUT_DIR, AS3_IMAGE_OUTPUT_DIR, AS3_TEMPLATE_FILE};
    }
}

