/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public abstract class MouseWheelSensor {
    private float inputScale = 1.0f;
    private float unitsCumulative;
    private boolean enabled = true;

    public MouseWheelSensor(Component target) {
        target.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getScrollType() == 0) {
                    MouseWheelSensor.this.onMouseWheel(e.getUnitsToScroll());
                }
            }
        });
    }

    public void reset() {
        this.unitsCumulative = 0.0f;
    }

    public void setInputScale(float inputScale) {
        this.inputScale = inputScale;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected abstract void update(float var1, float var2);

    private void onMouseWheel(int unitsToScroll) {
        float scaledUnits = this.inputScale * (float)unitsToScroll;
        this.unitsCumulative += scaledUnits;
        if (this.enabled) {
            this.update(scaledUnits, this.unitsCumulative);
        }
    }
}

