/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.util.LabeledRowPanel;
import com.sodiumarc.patchwork.util.Rectangle4d;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class MarginsPanel
extends JPanel {
    private JSpinner leftMarginSpinner = this.makeSpinner();
    private JSpinner rightMarginSpinner = this.makeSpinner();
    private JSpinner topMarginSpinner = this.makeSpinner();
    private JSpinner bottomMarginSpinner = this.makeSpinner();
    private ChangeListener spinnerListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            MarginsPanel.this.marginsChanged();
        }
    };

    public MarginsPanel() {
        this("Margins");
    }

    public MarginsPanel(String title) {
        super(new BorderLayout(5, 5));
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MarginsPanel.this.marginsCleared();
            }
        });
        ArrayList<LabeledRowPanel.LabeledRow> rows = new ArrayList<LabeledRowPanel.LabeledRow>();
        JPanel hMarginPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        hMarginPanel.add(this.leftMarginSpinner);
        hMarginPanel.add(this.rightMarginSpinner);
        rows.add(new LabeledRowPanel.LabeledRow("Margin (left/right):", (Component)hMarginPanel, true));
        JPanel vMarginPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        vMarginPanel.add(this.topMarginSpinner);
        vMarginPanel.add(this.bottomMarginSpinner);
        rows.add(new LabeledRowPanel.LabeledRow("Margin (top/bottom):", (Component)vMarginPanel, true));
        this.add((Component)new LabeledRowPanel(rows), "Center");
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)clearButton, "East");
        this.add((Component)southPanel, "South");
        if (title != null) {
            TitledBorder titleBorder = BorderFactory.createTitledBorder(title);
            Border emptyBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
            this.setBorder(BorderFactory.createCompoundBorder(titleBorder, emptyBorder));
        }
    }

    public void setMarginsRegion(Rectangle4d renderRegion) {
        this.setSpinner(this.leftMarginSpinner, -renderRegion.getX());
        this.setSpinner(this.topMarginSpinner, -renderRegion.getY());
        this.setSpinner(this.rightMarginSpinner, renderRegion.getX() + renderRegion.getWidth() - 1.0);
        this.setSpinner(this.bottomMarginSpinner, renderRegion.getY() + renderRegion.getHeight() - 1.0);
    }

    public Rectangle4d getMarginsRegion() {
        double x = -((Double)this.leftMarginSpinner.getValue()).doubleValue();
        double y = -((Double)this.topMarginSpinner.getValue()).doubleValue();
        double w = 1.0 + (Double)this.rightMarginSpinner.getValue() - x;
        double h = 1.0 + (Double)this.bottomMarginSpinner.getValue() - y;
        return new Rectangle4d(x, y, w, h);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.leftMarginSpinner.setEnabled(enabled);
        this.rightMarginSpinner.setEnabled(enabled);
        this.topMarginSpinner.setEnabled(enabled);
        this.bottomMarginSpinner.setEnabled(enabled);
    }

    protected abstract void marginsChanged();

    protected abstract void marginsCleared();

    private JSpinner makeSpinner() {
        JSpinner result = new JSpinner(new SpinnerNumberModel(0.0, -5.0, 5.0, 0.05));
        ((JSpinner.DefaultEditor)result.getEditor()).getTextField().setColumns(4);
        result.addChangeListener(this.spinnerListener);
        return result;
    }

    private void setSpinner(JSpinner spinner, double value) {
        spinner.removeChangeListener(this.spinnerListener);
        spinner.setValue(value);
        spinner.addChangeListener(this.spinnerListener);
    }
}

