/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.layeredimage.LayeredImagePanel;
import com.sodiumarc.patchwork.app.scanimport.ScanImportPanel;
import com.sodiumarc.patchwork.app.scenecomposer.MarginsPanel;
import com.sodiumarc.patchwork.app.scenecomposer.PatchworkComposerProperties;
import com.sodiumarc.patchwork.app.scenecomposer.PointPanel;
import com.sodiumarc.patchwork.app.scenecomposer.ProjectComponentPanel;
import com.sodiumarc.patchwork.app.scenecomposer.TraceImagePrintable;
import com.sodiumarc.patchwork.app.scenecomposer.TreeChooserButton;
import com.sodiumarc.patchwork.app.scenecomposer.model.IOFileType;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.InterpFunction;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LocationLayerGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.AbstractViewpoint;
import com.sodiumarc.patchwork.util.Collection.Range;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.OKCancelDialog;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class LocationLayerGraphicPanel<T extends LocationLayerGraphic>
extends ProjectComponentPanel<T> {
    private boolean commonSettingsInUse;
    private JCheckBox movingWindowCheckbox;
    private ActionListener movingWindowCheckBoxListener;
    private PointPanel sourceGridOffsetPanel;
    private PointPanel sourcePixelOffsetPanel;
    private JCheckBox flipHorizontalCheckBox;
    private JCheckBox flipVerticalCheckBox;
    private ActionListener flipListener;
    private TreeChooserButton overrideViewpointButton;
    private JComboBox interpFunctionCombo;
    private ActionListener interpFunctionListener;
    private JCheckBox interactiveAnimCheckBox;
    private ActionListener interactiveAnimListener;
    private JButton hazeColorButton;
    private JSpinner hazeAmountSpinner;
    private ChangeListener hazeAmountListener;
    private JSpinner marginFadeSpinner;
    private ChangeListener marginFadeListener;
    private MarginsPanel marginsPanel;
    private JFileChooser fileChooser;
    private ScanImportPanel scanImportPanel;
    private OKCancelDialog scanImportDialog;

    public LocationLayerGraphicPanel() {
    }

    public LocationLayerGraphicPanel(boolean showHeaderLabel) {
        super(showHeaderLabel);
    }

    @Override
    protected void targetSet() {
        super.targetSet();
        LocationLayerGraphic target = (LocationLayerGraphic)this.getTarget();
        if (this.marginsPanel != null) {
            if (target != null) {
                this.marginsPanel.setMarginsRegion(target.getMarginsRegion());
            } else {
                this.marginsPanel.setMarginsRegion(new Rectangle4d(0.0, 0.0, 1.0, 1.0));
            }
        }
        if (this.commonSettingsInUse) {
            this.movingWindowCheckbox.removeActionListener(this.movingWindowCheckBoxListener);
            this.interpFunctionCombo.removeActionListener(this.interpFunctionListener);
            this.hazeAmountSpinner.removeChangeListener(this.hazeAmountListener);
            this.marginFadeSpinner.removeChangeListener(this.marginFadeListener);
            this.interactiveAnimCheckBox.removeActionListener(this.interactiveAnimListener);
            if (target != null) {
                this.movingWindowCheckbox.setSelected(target.isMovingWindow());
                this.sourceGridOffsetPanel.setValue(target.getSourceGridOffset());
                this.sourcePixelOffsetPanel.setValue(target.getSourcePixelOffset());
                this.interactiveAnimCheckBox.setSelected(target.isInteractiveWhenAnimating());
                this.interpFunctionCombo.setSelectedItem(target.getInterpFunction());
                this.hazeColorButton.setBackground(target.getHazeColor());
                this.hazeAmountSpinner.setValue(new Double(target.getHazeAmount()));
                this.marginFadeSpinner.setValue(new Double(target.getMarginFade()));
                this.overrideViewpointButton.setChoiceRoot(target.getPath().get(0));
                this.overrideViewpointButton.setExpandRoot(target.getAncestorByType(SceneLocation.class));
                this.overrideViewpointButton.setSelected(target.getOverrideViewpoint());
            }
            this.movingWindowCheckbox.addActionListener(this.movingWindowCheckBoxListener);
            this.interpFunctionCombo.addActionListener(this.interpFunctionListener);
            this.hazeAmountSpinner.addChangeListener(this.hazeAmountListener);
            this.marginFadeSpinner.addChangeListener(this.marginFadeListener);
            this.interactiveAnimCheckBox.addActionListener(this.interactiveAnimListener);
            this.updateFlipCheckBoxes();
        }
    }

    protected final JComponent getCommonSettingsPanel() {
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setMultiSelectionEnabled(false);
        this.scanImportPanel = this.getScanImportPanel();
        this.scanImportDialog = new OKCancelDialog(SwingUtilities.getWindowAncestor(this), "Align Scan", this.scanImportPanel, Dialog.ModalityType.APPLICATION_MODAL, new Dimension(700, 700));
        this.movingWindowCheckbox = new JCheckBox();
        this.movingWindowCheckBoxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationLayerGraphic target = (LocationLayerGraphic)LocationLayerGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setMovingWindow(LocationLayerGraphicPanel.this.movingWindowCheckbox.isSelected());
                    LocationLayerGraphicPanel.this.fireTargetModified();
                }
            }
        };
        this.sourceGridOffsetPanel = new PointPanel(){

            @Override
            protected void valueChanged() {
                LocationLayerGraphic target = (LocationLayerGraphic)LocationLayerGraphicPanel.this.getTarget();
                if (target != null) {
                    Point value = LocationLayerGraphicPanel.this.sourceGridOffsetPanel.getValue();
                    target.setSourceGridOffset(value);
                    LocationLayerGraphicPanel.this.fireTargetModified();
                }
            }

            @Override
            protected Range<Integer> getRange() {
                return new Range<Integer>(-2, 2);
            }
        };
        this.sourcePixelOffsetPanel = new PointPanel(){

            @Override
            protected void valueChanged() {
                LocationLayerGraphic target = (LocationLayerGraphic)LocationLayerGraphicPanel.this.getTarget();
                if (target != null) {
                    Point value = LocationLayerGraphicPanel.this.sourcePixelOffsetPanel.getValue();
                    target.setSourcePixelOffset(value);
                    LocationLayerGraphicPanel.this.fireTargetModified();
                }
            }

            @Override
            protected Range<Integer> getRange() {
                return new Range<Integer>(-1000, 1000);
            }
        };
        this.flipHorizontalCheckBox = new JCheckBox("Horizontal");
        this.flipVerticalCheckBox = new JCheckBox("Vertical");
        this.flipListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationLayerGraphic target = (LocationLayerGraphic)LocationLayerGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setFlipHorizontal(LocationLayerGraphicPanel.this.flipHorizontalCheckBox.isSelected());
                    target.setFlipVertical(LocationLayerGraphicPanel.this.flipVerticalCheckBox.isSelected());
                    LocationLayerGraphicPanel.this.fireTargetModified();
                }
            }
        };
        this.overrideViewpointButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                LocationLayerGraphic target = (LocationLayerGraphic)LocationLayerGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setOverrideViewpoint((AbstractViewpoint)LocationLayerGraphicPanel.this.overrideViewpointButton.getSelected());
                    LocationLayerGraphicPanel.this.fireTargetModified();
                }
            }
        };
        this.interactiveAnimCheckBox = new JCheckBox();
        this.interactiveAnimListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationLayerGraphic target = (LocationLayerGraphic)LocationLayerGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setInteractiveWhenAnimating(LocationLayerGraphicPanel.this.interactiveAnimCheckBox.isSelected());
                    LocationLayerGraphicPanel.this.fireTargetModified();
                }
            }
        };
        this.interpFunctionCombo = new JComboBox<InterpFunction>(InterpFunction.values());
        this.interpFunctionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationLayerGraphic target = (LocationLayerGraphic)LocationLayerGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setInterpFunction((InterpFunction)LocationLayerGraphicPanel.this.interpFunctionCombo.getSelectedItem());
                    LocationLayerGraphicPanel.this.fireTargetModified();
                }
            }
        };
        this.hazeAmountSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.05));
        ((JSpinner.DefaultEditor)this.hazeAmountSpinner.getEditor()).getTextField().setColumns(4);
        this.hazeAmountListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LocationLayerGraphic target = (LocationLayerGraphic)LocationLayerGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setHazeAmount(((Double)LocationLayerGraphicPanel.this.hazeAmountSpinner.getValue()).floatValue());
                    LocationLayerGraphicPanel.this.fireTargetModified();
                }
            }
        };
        this.marginFadeSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.05));
        ((JSpinner.DefaultEditor)this.marginFadeSpinner.getEditor()).getTextField().setColumns(4);
        this.marginFadeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LocationLayerGraphic target = (LocationLayerGraphic)LocationLayerGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setMarginFade(((Double)LocationLayerGraphicPanel.this.marginFadeSpinner.getValue()).floatValue());
                    LocationLayerGraphicPanel.this.fireTargetModified();
                }
            }
        };
        this.hazeColorButton = new JButton("Choose...");
        this.hazeColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color hazeColor = JColorChooser.showDialog(LocationLayerGraphicPanel.this, "Haze Color", ((LocationLayerGraphic)LocationLayerGraphicPanel.this.getTarget()).getHazeColor());
                LocationLayerGraphicPanel.this.hazeColorButton.setBackground(hazeColor);
                ((LocationLayerGraphic)LocationLayerGraphicPanel.this.getTarget()).setHazeColor(hazeColor);
            }
        });
        JButton saveButton = new JButton("Save a Copy...");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationLayerGraphicPanel.this.saveACopy();
            }
        });
        JButton printButton = new JButton("Print Trace", IconLoader.loadIcon("silk/printer.png"));
        printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationLayerGraphicPanel.this.onPrintTrace();
            }
        });
        JButton importButton = new JButton("Import Trace", IconLoader.loadIcon("silk/page_white_picture.png"));
        importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationLayerGraphicPanel.this.onImportTrace();
            }
        });
        ArrayList<LabeledRowPanel.LabeledRow> rows = new ArrayList<LabeledRowPanel.LabeledRow>();
        rows.add(new LabeledRowPanel.LabeledRow("Moving Window:", (Component)this.movingWindowCheckbox));
        rows.add(new LabeledRowPanel.LabeledRow("Interactive Anim:", (Component)this.interactiveAnimCheckBox));
        rows.add(new LabeledRowPanel.LabeledRow("Interp Function:", (Component)this.interpFunctionCombo));
        JPanel hazePanel = new JPanel(new BorderLayout(5, 0));
        hazePanel.add((Component)this.hazeAmountSpinner, "West");
        hazePanel.add((Component)this.hazeColorButton, "Center");
        rows.add(new LabeledRowPanel.LabeledRow("Haze:", (Component)hazePanel));
        rows.add(new LabeledRowPanel.LabeledRow("Margin Fade:", (Component)this.marginFadeSpinner));
        rows.add(new LabeledRowPanel.LabeledRow("Source Offset (cols, rows):", (Component)this.sourceGridOffsetPanel));
        rows.add(new LabeledRowPanel.LabeledRow("Source Offset (x, y):", (Component)this.sourcePixelOffsetPanel));
        JPanel flipPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        flipPanel.add(this.flipHorizontalCheckBox);
        flipPanel.add(this.flipVerticalCheckBox);
        rows.add(new LabeledRowPanel.LabeledRow("Flip Image:", (Component)flipPanel));
        this.commonSettingsInUse = true;
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)new LabeledRowPanel(rows), "Center");
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        bottomPanel.add(saveButton);
        bottomPanel.add(printButton);
        bottomPanel.add(importButton);
        result.add((Component)bottomPanel, "South");
        TitledBorder titleBorder = BorderFactory.createTitledBorder("Graphic");
        Border emptyBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        result.setBorder(BorderFactory.createCompoundBorder(titleBorder, emptyBorder));
        return result;
    }

    protected final JComponent getMarginsPanel() {
        this.marginsPanel = new MarginsPanel(){

            @Override
            protected void marginsChanged() {
                LocationLayerGraphic target = (LocationLayerGraphic)LocationLayerGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setMarginsRegion(LocationLayerGraphicPanel.this.marginsPanel.getMarginsRegion());
                    LocationLayerGraphicPanel.this.fireTargetModified();
                }
            }

            @Override
            protected void marginsCleared() {
                LocationLayerGraphic target = (LocationLayerGraphic)LocationLayerGraphicPanel.this.getTarget();
                if (target != null) {
                    target.setMarginsRegion(null);
                    LocationLayerGraphicPanel.this.marginsPanel.setMarginsRegion(target.getMarginsRegion());
                    LocationLayerGraphicPanel.this.fireTargetModified();
                }
            }
        };
        return this.marginsPanel;
    }

    protected ScanImportPanel getScanImportPanel() {
        return new ScanImportPanel();
    }

    protected BufferedImage getTraceFillImage() {
        LocationLayerGraphic target = (LocationLayerGraphic)this.getTarget();
        if (target == null) {
            return null;
        }
        return target.getImage(0.0f);
    }

    protected Printable getTracePrintable(float alpha) {
        LocationLayerGraphic target = (LocationLayerGraphic)this.getTarget();
        if (target == null) {
            return null;
        }
        return new TraceImagePrintable(Collections.singletonList(target.getImage(0.0f)), alpha);
    }

    protected void saveACopy() {
        LocationLayerGraphic target = (LocationLayerGraphic)this.getTarget();
        if (target == null) {
            return;
        }
        File snapshotDir = PatchworkComposerProperties.getIODirectory(IOFileType.SNAPSHOT);
        BufferedImage snapshot = target.getImage(0.0f);
        String filename = target.getIDPath(3) + ".png";
        this.saveImage(snapshot, snapshotDir, filename);
    }

    private void saveImage(BufferedImage image, File directory, String filename) {
        this.fileChooser.resetChoosableFileFilters();
        this.fileChooser.addChoosableFileFilter(LayeredImagePanel.IMAGE_FILTER);
        this.fileChooser.setSelectedFile(new File(directory, filename));
        int result = this.fileChooser.showSaveDialog(SwingUtilities.getRoot(this));
        if (result == 0) {
            int confirm;
            File file = this.fileChooser.getSelectedFile();
            if (file.exists() && (confirm = JOptionPane.showConfirmDialog(this, "File exists. Overwrite?", "Confirm Overwrite", 0)) != 0) {
                return;
            }
            if (image != null) {
                try {
                    ImageUtils.saveImage(image, file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void onPrintTrace() {
        float traceAlpha = 0.3f;
        String alphaStr = JOptionPane.showInputDialog(this, "Trace Opacity:", Float.valueOf(traceAlpha));
        if (alphaStr != null) {
            try {
                traceAlpha = Float.parseFloat(alphaStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        MathUtils.clamp(traceAlpha, 0.0f, 1.0f);
        Printable printable = this.getTracePrintable(traceAlpha);
        if (printable == null) {
            return;
        }
        final PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(printable);
        boolean ok = job.printDialog();
        if (ok) {
            new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    try {
                        job.print();
                    }
                    catch (PrinterException ex) {
                        ex.printStackTrace();
                    }
                    return null;
                }

                @Override
                protected void done() {
                }
            }.execute();
        }
    }

    private void onImportTrace() {
        LocationLayerGraphic target = (LocationLayerGraphic)this.getTarget();
        if (target == null) {
            return;
        }
        File rawScanDir = PatchworkComposerProperties.getIODirectory(IOFileType.RAW_SCANS);
        this.fileChooser.resetChoosableFileFilters();
        this.fileChooser.addChoosableFileFilter(LayeredImagePanel.IMAGE_FILTER);
        this.fileChooser.setCurrentDirectory(rawScanDir);
        int result = this.fileChooser.showOpenDialog(SwingUtilities.getRoot(this));
        if (result == 0) {
            File file = this.fileChooser.getSelectedFile();
            BufferedImage image = null;
            try {
                image = ImageIO.read(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (image != null) {
                BufferedImage processedImage;
                this.scanImportPanel.setRawScanImage(image);
                this.scanImportPanel.setFillImage(this.getTraceFillImage());
                OKCancelDialog.Result dialogResult = this.scanImportDialog.showOKCancelDialog(this);
                if (dialogResult == OKCancelDialog.Result.OK && (processedImage = this.scanImportPanel.getProcessedImage()) != null) {
                    File outputDir = PatchworkComposerProperties.getIODirectory(IOFileType.LAYER_SCANS);
                    String filename = target.getIDPath(3) + ".png";
                    this.saveImage(processedImage, outputDir, filename);
                }
            }
        }
    }

    private void updateFlipCheckBoxes() {
        LocationLayerGraphic target = (LocationLayerGraphic)this.getTarget();
        this.flipHorizontalCheckBox.removeActionListener(this.flipListener);
        this.flipVerticalCheckBox.removeActionListener(this.flipListener);
        if (target != null) {
            this.flipHorizontalCheckBox.setSelected(target.isFlipHorizontal());
            this.flipVerticalCheckBox.setSelected(target.isFlipVertical());
        } else {
            this.flipHorizontalCheckBox.setSelected(false);
            this.flipVerticalCheckBox.setSelected(false);
        }
        this.flipHorizontalCheckBox.addActionListener(this.flipListener);
        this.flipVerticalCheckBox.addActionListener(this.flipListener);
    }
}

