/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class ListEditPanel<T>
extends JPanel {
    private final ListSelectionListener selectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListEditPanel.this.updateControlEnabling();
        }
    };
    private final JList list;
    private final DefaultListModel listModel = new DefaultListModel();
    private final JButton addButton;
    private final JButton deleteButton;
    private final JButton editButton;
    private boolean enabled;

    public ListEditPanel(Icon addIcon, Icon deleteIcon, Icon editIcon) {
        super(new BorderLayout());
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ListEditPanel.this.onEdit(ListEditPanel.this.getCurrentSelection());
                    ListEditPanel.this.update();
                }
            }
        });
        this.add((Component)new JScrollPane(this.list), "Center");
        JPanel buttonPanel = new JPanel(new GridLayout(1, 3, 2, 2));
        this.addButton = new JButton("Add", addIcon);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object newElement = ListEditPanel.this.onAdd();
                ListEditPanel.this.update();
                ListEditPanel.this.onEdit(newElement);
            }
        });
        buttonPanel.add(this.addButton);
        this.deleteButton = new JButton("Delete", deleteIcon);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListEditPanel.this.onDelete(ListEditPanel.this.getCurrentSelection());
                ListEditPanel.this.update();
            }
        });
        buttonPanel.add(this.deleteButton);
        this.editButton = new JButton("Edit", editIcon);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListEditPanel.this.onEdit(ListEditPanel.this.getCurrentSelection());
                ListEditPanel.this.update();
            }
        });
        buttonPanel.add(this.editButton);
        this.add((Component)buttonPanel, "South");
        this.list.addListSelectionListener(this.selectionListener);
    }

    public T getCurrentSelection() {
        return (T)this.list.getSelectedValue();
    }

    public void update() {
        this.list.removeListSelectionListener(this.selectionListener);
        List<T> contents = this.getContents();
        Object previousSelection = this.list.getSelectedValue();
        this.listModel.clear();
        Object newSelection = null;
        if (contents != null) {
            for (Object element : contents) {
                this.listModel.addElement(element);
                if (!element.equals(previousSelection)) continue;
                newSelection = element;
            }
        }
        if (newSelection != null) {
            this.list.setSelectedValue(newSelection, false);
        }
        this.list.addListSelectionListener(this.selectionListener);
        this.updateControlEnabling();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enabled = enabled;
        this.list.setEnabled(enabled);
        this.updateControlEnabling();
    }

    protected abstract List<T> getContents();

    protected abstract T onAdd();

    protected abstract void onDelete(T var1);

    protected abstract void onEdit(T var1);

    private void updateControlEnabling() {
        T selection = this.getCurrentSelection();
        this.addButton.setEnabled(this.enabled);
        this.deleteButton.setEnabled(this.enabled && selection != null);
        this.editButton.setEnabled(this.enabled && selection != null);
    }
}

