/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.scenecomposer.ProjectComponentPanel;
import com.sodiumarc.patchwork.app.scenecomposer.TreeChooserButton;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Scene;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocation;
import com.sodiumarc.patchwork.app.scenecomposer.model.viewpoint.InterpolatedViewpoint;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InterpolatedViewpointPanel
extends ProjectComponentPanel<InterpolatedViewpoint> {
    private ChangeListener spinnerListener;
    private TreeChooserButton fromLocationButton;
    private TreeChooserButton toLocationButton;
    private JSpinner fractionSpinner;

    @Override
    protected void targetSet() {
        super.targetSet();
        InterpolatedViewpoint location = (InterpolatedViewpoint)this.getTarget();
        Scene scene = location == null ? null : location.getAncestorByType(Scene.class);
        this.fromLocationButton.setChoiceRoot(scene);
        this.toLocationButton.setChoiceRoot(scene);
        this.fractionSpinner.removeChangeListener(this.spinnerListener);
        if (location != null) {
            this.fromLocationButton.setSelected(location.getFromLocation());
            this.toLocationButton.setSelected(location.getToLocation());
            this.fractionSpinner.setValue(location.getInterpFraction());
        }
        this.fractionSpinner.addChangeListener(this.spinnerListener);
    }

    @Override
    protected JComponent getMainArea() {
        HashSet types = new HashSet();
        types.add(SceneLocation.class);
        this.fromLocationButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ((InterpolatedViewpoint)InterpolatedViewpointPanel.this.getTarget()).setFromLocation((SceneLocation)selection);
                InterpolatedViewpointPanel.this.fireTargetModified();
            }
        };
        this.fromLocationButton.setEnabledTypes(types);
        this.toLocationButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ((InterpolatedViewpoint)InterpolatedViewpointPanel.this.getTarget()).setToLocation((SceneLocation)selection);
                InterpolatedViewpointPanel.this.fireTargetModified();
            }
        };
        this.toLocationButton.setEnabledTypes(types);
        this.fractionSpinner = new JSpinner(new SpinnerNumberModel(0.5, 0.0, 1.0, 0.1));
        ((JSpinner.DefaultEditor)this.fractionSpinner.getEditor()).getTextField().setColumns(4);
        this.spinnerListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ((InterpolatedViewpoint)InterpolatedViewpointPanel.this.getTarget()).setInterpFraction((Double)InterpolatedViewpointPanel.this.fractionSpinner.getValue());
                InterpolatedViewpointPanel.this.fireTargetModified();
            }
        };
        this.fractionSpinner.addChangeListener(this.spinnerListener);
        ArrayList<LabeledRowPanel.LabeledRow> rows = new ArrayList<LabeledRowPanel.LabeledRow>();
        rows.add(new LabeledRowPanel.LabeledRow("From Location: ", (Component)this.fromLocationButton, true));
        rows.add(new LabeledRowPanel.LabeledRow("To Location: ", (Component)this.toLocationButton, true));
        rows.add(new LabeledRowPanel.LabeledRow("Fraction: ", (Component)this.fractionSpinner));
        return new LabeledRowPanel("Interpolation", rows);
    }
}

