/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.scenecomposer.ColladaFileComboBox;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class ImportKeyframesPanel
extends LabeledRowPanel {
    private ColladaFileComboBox filenameCombo = new ColladaFileComboBox();
    private JComboBox nodeNameCombo;
    private LabeledRowPanel.LabeledRow nodeNameRow;
    private ActionListener filenameComboListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ImportKeyframesPanel.this.filenameChanged((String)ImportKeyframesPanel.this.filenameCombo.getSelectedItem());
            ImportKeyframesPanel.this.updateNodeIDCombo();
        }
    };
    private ActionListener nodeNameComboListener;
    private JSpinner startFrameSpinner;
    private ChangeListener spinnerListener;

    public ImportKeyframesPanel() {
        super("Import COLLADA keyframes");
        this.nodeNameCombo = new JComboBox();
        this.nodeNameComboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportKeyframesPanel.this.animationNodeNameChanged((String)ImportKeyframesPanel.this.nodeNameCombo.getSelectedItem());
            }
        };
        this.startFrameSpinner = this.makeSpinner();
        this.spinnerListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ImportKeyframesPanel.this.startFrameChanged((Integer)ImportKeyframesPanel.this.startFrameSpinner.getValue());
            }
        };
        ArrayList<LabeledRowPanel.LabeledRow> colladaRows = new ArrayList<LabeledRowPanel.LabeledRow>();
        colladaRows.add(new LabeledRowPanel.LabeledRow("Input Filename:", (Component)this.filenameCombo, true));
        this.nodeNameRow = new LabeledRowPanel.LabeledRow("Node ID:", (Component)this.nodeNameCombo, true);
        colladaRows.add(this.nodeNameRow);
        colladaRows.add(new LabeledRowPanel.LabeledRow("Start Frame:", (Component)this.startFrameSpinner));
        this.setRows(colladaRows);
        this.updateNodeIDCombo();
    }

    public void update() {
        this.filenameCombo.removeActionListener(this.filenameComboListener);
        this.filenameCombo.setColladaParentDir(this.getColladaParentDir());
        this.filenameCombo.setSelectedItem(this.getFilename());
        this.setSpinner(this.startFrameSpinner, this.getStartFrame());
        this.updateNodeIDCombo();
        this.filenameCombo.addActionListener(this.filenameComboListener);
    }

    protected abstract File getColladaParentDir();

    protected abstract String getFilename();

    protected abstract String getAnimationNodeName();

    protected abstract List<String> getAnimationNodeNames();

    protected abstract void filenameChanged(String var1);

    protected abstract void animationNodeNameChanged(String var1);

    protected abstract int getStartFrame();

    protected abstract void startFrameChanged(int var1);

    private void updateNodeIDCombo() {
        this.nodeNameCombo.removeActionListener(this.nodeNameComboListener);
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel();
        this.nodeNameRow.setEnabled(false);
        List<String> nodeIDs = this.getAnimationNodeNames();
        nodeIDs.add(0, null);
        model = new DefaultComboBoxModel<Object>(nodeIDs.toArray());
        this.nodeNameRow.setEnabled(!nodeIDs.isEmpty());
        this.nodeNameCombo.setModel(model);
        this.nodeNameCombo.setSelectedItem(this.getAnimationNodeName());
        this.nodeNameCombo.addActionListener(this.nodeNameComboListener);
    }

    private JSpinner makeSpinner() {
        JSpinner result = new JSpinner(new SpinnerNumberModel(0, 0, 1000, 1));
        ((JSpinner.DefaultEditor)result.getEditor()).getTextField().setColumns(4);
        result.addChangeListener(this.spinnerListener);
        return result;
    }

    private void setSpinner(JSpinner spinner, double value) {
        spinner.removeChangeListener(this.spinnerListener);
        spinner.setValue(value);
        spinner.addChangeListener(this.spinnerListener);
    }
}

