/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.scenecomposer.LocationLayerGraphicPanel;
import com.sodiumarc.patchwork.app.scenecomposer.ProjectComponentList;
import com.sodiumarc.patchwork.app.scenecomposer.TreeChooserButton;
import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLocationLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.HoleGraphic;
import com.sodiumarc.patchwork.app.scenecomposer.model.graphic.LocationLayerGraphic;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class HoleGraphicPanel
extends LocationLayerGraphicPanel<HoleGraphic> {
    private TreeChooserButton maskGraphicButton;
    private TreeChooserButton showCardButton;
    private ProjectComponentList<SceneLayerState> stateList;

    @Override
    protected JComponent getMainArea() {
        this.maskGraphicButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ((HoleGraphic)HoleGraphicPanel.this.getTarget()).setMaskGraphic((LocationLayerGraphic)selection);
                HoleGraphicPanel.this.fireTargetModified();
            }
        };
        this.maskGraphicButton.setEnabledType(LocationLayerGraphic.class);
        this.showCardButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ((HoleGraphic)HoleGraphicPanel.this.getTarget()).setShowCard((Card)selection);
                HoleGraphicPanel.this.fireTargetModified();
            }
        };
        this.showCardButton.setEnabledType(Card.class);
        this.stateList = new ProjectComponentList<SceneLayerState>("Blank Fill States", SceneLayerState.class, 1, false){

            @Override
            protected void selectionChanged(List<SceneLayerState> selected) {
                HoleGraphic target = (HoleGraphic)HoleGraphicPanel.this.getTarget();
                if (target != null) {
                    target.clearBlankFillStates();
                    for (SceneLayerState state : selected) {
                        target.addBlankFillState(state);
                    }
                    HoleGraphicPanel.this.fireTargetModified();
                }
            }
        };
        ArrayList<LabeledRowPanel.LabeledRow> rows = new ArrayList<LabeledRowPanel.LabeledRow>();
        rows.add(new LabeledRowPanel.LabeledRow("Mask Graphic:", (Component)this.maskGraphicButton, true));
        rows.add(new LabeledRowPanel.LabeledRow("Show Card:", (Component)this.showCardButton, true));
        JPanel result = new JPanel(new BorderLayout(0, 10));
        result.add((Component)new LabeledRowPanel(rows), "North");
        result.add(this.stateList, "Center");
        return result;
    }

    @Override
    protected void targetSet() {
        super.targetSet();
        HoleGraphic target = (HoleGraphic)this.getTarget();
        this.stateList.clear();
        if (target != null) {
            this.maskGraphicButton.setChoiceRoot(target.getAncestorByType(Card.class));
            this.maskGraphicButton.setExpandRoot(target.getParentComponent());
            this.maskGraphicButton.setSelected(target.getMaskGraphic());
            this.showCardButton.setChoiceRoot(target.getPath().get(0));
            this.showCardButton.setExpandRoot(target.getPath().get(0));
            this.showCardButton.setSelected(target.getShowCard());
            ArrayList<SceneLayerState> states = new ArrayList<SceneLayerState>();
            SceneLocationLayer locationLayer = target.getAncestorByType(SceneLocationLayer.class);
            SceneLayer sceneLayer = locationLayer.getSceneLayer();
            if (sceneLayer != null) {
                states.addAll(sceneLayer.getStates());
                this.stateList.setContents(states, target.getBlankFillStates());
            }
        } else {
            this.maskGraphicButton.setChoiceRoot(null);
            this.maskGraphicButton.setChoiceRoot(null);
            this.maskGraphicButton.setSelected(null);
            this.showCardButton.setChoiceRoot(null);
            this.showCardButton.setExpandRoot(null);
            this.showCardButton.setSelected(null);
        }
    }
}

