/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scenecomposer;

import com.sodiumarc.patchwork.app.scenecomposer.ProjectComponentList;
import com.sodiumarc.patchwork.app.scenecomposer.ProjectComponentPanel;
import com.sodiumarc.patchwork.app.scenecomposer.TreeChooserButton;
import com.sodiumarc.patchwork.app.scenecomposer.model.Card;
import com.sodiumarc.patchwork.app.scenecomposer.model.GridDirection;
import com.sodiumarc.patchwork.app.scenecomposer.model.ProjectComponent;
import com.sodiumarc.patchwork.app.scenecomposer.model.Scene;
import com.sodiumarc.patchwork.app.scenecomposer.model.SceneLayer;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.CardLink;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.Predicate;
import com.sodiumarc.patchwork.app.scenecomposer.model.behavior.SceneLayerState;
import com.sodiumarc.patchwork.app.scenecomposer.table.CardLinkPredicateTable;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import com.sodiumarc.patchwork.util.TargetablePanel;
import com.sodiumarc.patchwork.util.TargetablePanelListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class CardLinkPanel
extends ProjectComponentPanel<CardLink> {
    private TreeChooserButton otherCardButton;
    private JComboBox directionCombo;
    private ActionListener directionComboListener;
    private JCheckBox originatorCheckBox;
    private ActionListener checkBoxListener;
    private LabeledRowPanel.LabeledRow checkBoxRow;
    private JComboBox operatorCombo;
    private ActionListener operatorComboListener;
    private LabeledRowPanel.LabeledRow formulaRow;
    private JTextField operatorFormulaField;
    private FormulaFieldListener formulaFieldListener;
    private ProjectComponentList<SceneLayerState> stateList;
    private CardLinkPredicateTable predicateTable;

    @Override
    protected JComponent getMainArea() {
        this.otherCardButton = new TreeChooserButton(){

            @Override
            protected void selectionChanged(ProjectComponent selection) {
                ((CardLink)CardLinkPanel.this.getTarget()).setOtherCard((Card)selection);
                CardLinkPanel.this.fireTargetModified();
            }
        };
        HashSet types = new HashSet();
        types.add(Card.class);
        this.otherCardButton.setEnabledTypes(types);
        this.directionCombo = new JComboBox<GridDirection>(GridDirection.values());
        this.directionComboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CardLink target = (CardLink)CardLinkPanel.this.getTarget();
                if (target != null) {
                    target.setDirection((GridDirection)((Object)CardLinkPanel.this.directionCombo.getSelectedItem()));
                    CardLinkPanel.this.updateEnabling();
                    CardLinkPanel.this.fireTargetModified();
                }
            }
        };
        this.originatorCheckBox = new JCheckBox();
        this.checkBoxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CardLink target = (CardLink)CardLinkPanel.this.getTarget();
                if (target != null) {
                    target.setOriginator(CardLinkPanel.this.originatorCheckBox.isSelected());
                    CardLinkPanel.this.fireTargetModified();
                }
            }
        };
        this.checkBoxRow = new LabeledRowPanel.LabeledRow("Originator:", (Component)this.originatorCheckBox, true);
        this.operatorCombo = new JComboBox<Predicate.Operator>(Predicate.Operator.values());
        this.operatorComboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CardLink target = (CardLink)CardLinkPanel.this.getTarget();
                if (target != null) {
                    target.setPredicateOperator((Predicate.Operator)((Object)CardLinkPanel.this.operatorCombo.getSelectedItem()));
                    CardLinkPanel.this.updateEnabling();
                    CardLinkPanel.this.fireTargetModified();
                }
            }
        };
        this.operatorFormulaField = new JTextField(20);
        this.formulaFieldListener = new FormulaFieldListener();
        this.operatorFormulaField.addFocusListener(this.formulaFieldListener);
        this.stateList = new ProjectComponentList<SceneLayerState>("Attach to States", SceneLayerState.class, 2, false){

            @Override
            protected void selectionChanged(List<SceneLayerState> selected) {
                CardLink target = (CardLink)CardLinkPanel.this.getTarget();
                if (target != null) {
                    target.clearAttachedStates();
                    for (SceneLayerState state : selected) {
                        target.addAttachedState(state);
                    }
                    CardLinkPanel.this.fireTargetModified();
                }
            }
        };
        this.predicateTable = new CardLinkPredicateTable();
        this.predicateTable.addListener(new TargetablePanelListener(){

            @Override
            public void targetModified(TargetablePanel<?> source) {
                CardLinkPanel.this.fireTargetModified();
            }

            @Override
            public void targetChanged(TargetablePanel<?> source) {
            }
        });
        ArrayList<LabeledRowPanel.LabeledRow> rows = new ArrayList<LabeledRowPanel.LabeledRow>();
        rows.add(new LabeledRowPanel.LabeledRow("Other Card:", (Component)this.otherCardButton, true));
        rows.add(new LabeledRowPanel.LabeledRow("Direction:", (Component)this.directionCombo, true));
        rows.add(this.checkBoxRow);
        ArrayList<LabeledRowPanel.LabeledRow> predicateRows = new ArrayList<LabeledRowPanel.LabeledRow>();
        predicateRows.add(new LabeledRowPanel.LabeledRow("Predicate Rule:", (Component)this.operatorCombo));
        this.formulaRow = new LabeledRowPanel.LabeledRow("Predicate Formula:", (Component)this.operatorFormulaField, true);
        this.formulaRow.setEnabled(false);
        predicateRows.add(this.formulaRow);
        JPanel predicatePanel = new JPanel(new BorderLayout(5, 5));
        predicatePanel.add((Component)new LabeledRowPanel(predicateRows), "North");
        predicatePanel.add((Component)this.predicateTable, "Center");
        TitledBorder titleBorder = BorderFactory.createTitledBorder("Predicates");
        Border emptyBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        CompoundBorder outerBorder = BorderFactory.createCompoundBorder(titleBorder, emptyBorder);
        predicatePanel.setBorder(outerBorder);
        JPanel result = new JPanel(new BorderLayout(0, 10));
        result.add((Component)new LabeledRowPanel(rows), "North");
        result.add(this.stateList, "Center");
        result.add((Component)predicatePanel, "South");
        return result;
    }

    @Override
    protected void targetSet() {
        super.targetSet();
        CardLink target = (CardLink)this.getTarget();
        this.stateList.clear();
        this.operatorCombo.removeActionListener(this.operatorComboListener);
        this.operatorFormulaField.removeActionListener(this.formulaFieldListener);
        this.directionCombo.removeActionListener(this.directionComboListener);
        this.originatorCheckBox.removeActionListener(this.checkBoxListener);
        if (target != null) {
            this.otherCardButton.setChoiceRoot(target.getPath().get(0));
            this.otherCardButton.setExpandRoot(target.getAncestorByType(Scene.class));
            this.otherCardButton.setSelected(target.getOtherCard());
            this.directionCombo.setSelectedItem((Object)target.getDirection());
            this.originatorCheckBox.setSelected(target.isOriginating());
            this.operatorCombo.setSelectedItem((Object)target.getPredicateOperator());
            this.operatorFormulaField.setText(target.getPredicateFormula());
            ArrayList<SceneLayerState> states = new ArrayList<SceneLayerState>();
            Scene scene = target.getAncestorByType(Scene.class);
            if (scene != null) {
                for (SceneLayer sceneLayer : scene.getSceneLayers()) {
                    states.addAll(sceneLayer.getStates());
                }
                this.stateList.setContents(states, target.getAttachedStates());
            }
        } else {
            this.otherCardButton.setChoiceRoot(null);
            this.otherCardButton.setExpandRoot(null);
            this.otherCardButton.setSelected(null);
            this.directionCombo.setSelectedIndex(0);
            this.originatorCheckBox.setSelected(false);
            this.operatorFormulaField.setText(null);
        }
        this.operatorCombo.addActionListener(this.operatorComboListener);
        this.operatorFormulaField.addActionListener(this.formulaFieldListener);
        this.directionCombo.addActionListener(this.directionComboListener);
        this.originatorCheckBox.addActionListener(this.checkBoxListener);
        this.predicateTable.setTarget(target);
        this.updateEnabling();
    }

    private void updateEnabling() {
        this.checkBoxRow.setEnabled(this.directionCombo.getSelectedItem() == GridDirection.UNDER || this.directionCombo.getSelectedItem() == GridDirection.OVER);
        this.formulaRow.setEnabled(this.operatorCombo.getSelectedItem() == Predicate.Operator.FORMULA);
    }

    private void onFormulaChanged() {
        CardLink target = (CardLink)this.getTarget();
        if (target != null) {
            String text = this.operatorFormulaField.getText();
            if (text != null && text.trim().isEmpty()) {
                text = null;
            }
            target.setPredicateFormula(text);
            this.fireTargetModified();
        }
    }

    private class FormulaFieldListener
    implements ActionListener,
    FocusListener {
        private FormulaFieldListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            CardLinkPanel.this.onFormulaChanged();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CardLinkPanel.this.onFormulaChanged();
        }
    }
}

