/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scanimport;

import com.sodiumarc.patchwork.FileUtils;
import com.sodiumarc.patchwork.app.ApplicationProperties;
import com.sodiumarc.patchwork.render.RenderResourceIO;
import com.sodiumarc.patchwork.sketch.SketchAsset;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ScanQuickApp {
    public static void main(String[] args) {
        ApplicationProperties.load();
        String filename = args[0];
        RenderResourceIO resourceIO = RenderResourceIO.getInstance();
        try {
            File inputFile = new File(resourceIO.getRawScanDir(), filename);
            BufferedImage inputImage = ImageIO.read(inputFile);
            SketchAsset asset = new SketchAsset("dummy", inputImage, 1.0f, 1.0f);
            BufferedImage processedImage = asset.makeSplotchImage(Color.BLACK, true);
            resourceIO.writeOutputImage(processedImage, resourceIO.getProcessedScanDir(), FileUtils.getFilenameWithoutExtension(filename));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Done.");
    }
}

