/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scanimport;

import com.sodiumarc.patchwork.FileUtils;
import com.sodiumarc.patchwork.app.ApplicationProperties;
import com.sodiumarc.patchwork.app.pipeline.LayerImagePrintable;
import com.sodiumarc.patchwork.app.scanimport.AlignmentPanel;
import com.sodiumarc.patchwork.app.scanimport.ScanImportPanel;
import com.sodiumarc.patchwork.render.RenderResourceIO;
import com.sodiumarc.patchwork.render.control.ImageOutputID;
import com.sodiumarc.patchwork.render.control.ImageOutputLayerID;
import com.sodiumarc.patchwork.render.control.RenderControl;
import com.sodiumarc.patchwork.render.control.RenderImage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class ScanImportApp
extends JFrame {
    public static String TITLE = "Pipeline Application";
    private ScanImportPanel imagePanel;
    private JButton loadButton;
    private JButton splitButton;
    private JFileChooser fileChooser;
    private JTextField topTextField;
    private JTextField middleTextField;
    private JTextField bottomTextField;
    private AlignmentPanel alignmentPanel;
    private JDialog alignmentDialog;
    private final ExecutorService appThread = Executors.newSingleThreadExecutor();

    public static void main(String[] args) {
        ApplicationProperties.load();
        ApplicationProperties.parseArgs(args);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new ScanImportApp();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public ScanImportApp() throws HeadlessException {
        super(TITLE);
        this.fileChooser = new JFileChooser();
        this.fileChooser.setCurrentDirectory(RenderResourceIO.getInstance().getRawScanDir());
        this.fileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return ".jpg files";
            }

            @Override
            public boolean accept(File f) {
                return FileUtils.hasFileExtension(f.getName(), "jpg");
            }
        });
        this.alignmentPanel = new AlignmentPanel();
        this.alignmentDialog = new JDialog((Frame)this, true);
        this.alignmentDialog.setContentPane(this.alignmentPanel);
        this.alignmentDialog.pack();
        this.alignmentDialog.setSize(500, 500);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ScanImportApp.this.exit();
            }
        });
        this.setContentPane(this.createContentPane());
        this.updateControlEnabling();
        this.pack();
        this.setSize(new Dimension(700, 600));
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void exit() {
        this.appThread.shutdownNow();
        System.exit(0);
    }

    private JComponent createContentPane() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.createMainPanel(), "Center");
        panel.add(this.createButtonPanel(), "South");
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return panel;
    }

    private Component createButtonPanel() {
        this.loadButton = new JButton("Load");
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ScanImportApp.this.doLoad();
            }
        });
        this.splitButton = new JButton("Split");
        this.splitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ScanImportApp.this.doSplit();
            }
        });
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ScanImportApp.this.exit();
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(this.loadButton);
        buttonPanel.add(this.splitButton);
        buttonPanel.add(closeButton);
        return buttonPanel;
    }

    private Component createMainPanel() {
        this.imagePanel = new ScanImportPanel();
        this.imagePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ScanImportApp.this.updateControlEnabling();
            }
        });
        JPanel panel = new JPanel(new BorderLayout(0, 10));
        JScrollPane scrollPane = new JScrollPane(this.imagePanel);
        scrollPane.setVerticalScrollBarPolicy(22);
        panel.add((Component)scrollPane, "Center");
        panel.add(this.createTextEntryPanel(), "South");
        return panel;
    }

    private Component createTextEntryPanel() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScanImportApp.this.updateControlEnabling();
            }
        };
        this.topTextField = new JTextField();
        this.topTextField.addActionListener(listener);
        this.middleTextField = new JTextField();
        this.middleTextField.addActionListener(listener);
        this.bottomTextField = new JTextField();
        this.bottomTextField.addActionListener(listener);
        JPanel panel = new JPanel(new BorderLayout(10, 0));
        JPanel labelPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        labelPanel.add(new JLabel("Top:"));
        labelPanel.add(new JLabel("Middle:"));
        labelPanel.add(new JLabel("Bottom:"));
        JPanel textFieldPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        textFieldPanel.add(this.topTextField);
        textFieldPanel.add(this.middleTextField);
        textFieldPanel.add(this.bottomTextField);
        panel.add((Component)labelPanel, "West");
        panel.add((Component)textFieldPanel, "Center");
        return panel;
    }

    private void updateControlEnabling() {
        boolean nonEmptyText = this.getImageID(this.topTextField.getText()) != null || this.getImageID(this.middleTextField.getText()) != null || this.getImageID(this.bottomTextField.getText()) != null;
        this.splitButton.setEnabled(nonEmptyText && this.imagePanel.getProcessedImage() != null && this.imagePanel.getChosenPoints().size() == 2);
        this.topTextField.setEnabled(this.imagePanel.getProcessedImage() != null);
        this.middleTextField.setEnabled(this.imagePanel.getProcessedImage() != null);
        this.bottomTextField.setEnabled(this.imagePanel.getProcessedImage() != null);
    }

    private void doLoad() {
        int result = this.fileChooser.showOpenDialog(this);
        if (result == 0) {
            File file = this.fileChooser.getSelectedFile();
            BufferedImage image = null;
            try {
                image = ImageIO.read(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (image != null) {
                this.imagePanel.setRawScanImage(image);
            }
            String name = FileUtils.getFilenameWithoutExtension(file.getName());
            String stem = null;
            int splitIndex = name.indexOf(45);
            if (splitIndex != -1) {
                stem = name.substring(0, splitIndex);
            }
            this.topTextField.setText(stem);
            this.middleTextField.setText(stem);
            this.bottomTextField.setText(stem);
            this.updateControlEnabling();
        }
    }

    private void doSplit() {
        Object bottomID;
        Object middleID;
        Point bottomPoint;
        Point topPoint;
        List<Point> points = this.imagePanel.getChosenPoints();
        if (points.get((int)0).y > points.get((int)1).y) {
            topPoint = points.get(1);
            bottomPoint = points.get(0);
        } else {
            topPoint = points.get(0);
            bottomPoint = points.get(1);
        }
        BufferedImage image = this.imagePanel.getProcessedImage();
        double deltaX = bottomPoint.x - topPoint.x;
        double deltaY = bottomPoint.y - topPoint.y;
        double correctionAngle = Math.atan(deltaX / deltaY);
        AffineTransform at = new AffineTransform();
        at.rotate(correctionAngle, topPoint.getX(), topPoint.getY());
        AffineTransformOp imageOp = new AffineTransformOp(at, 3);
        BufferedImage rotatedImage = imageOp.filter(image, null);
        Point2D topRotated = at.transform(topPoint, null);
        Point2D bottomRotated = at.transform(bottomPoint, null);
        topPoint = new Point((int)topRotated.getX(), (int)topRotated.getY());
        bottomPoint = new Point((int)bottomRotated.getX(), (int)bottomRotated.getY());
        Dimension cellSize = new Dimension(rotatedImage.getWidth() - topPoint.x, bottomPoint.y - topPoint.y);
        Map<Object, BufferedImage> splitImages = new HashMap<Object, BufferedImage>();
        Object topID = this.getImageID(this.topTextField.getText());
        if (topID != null) {
            BufferedImage topImage = rotatedImage.getSubimage(topPoint.x, Math.max(0, topPoint.y - cellSize.height), cellSize.width, cellSize.height);
            splitImages.put(topID, topImage);
        }
        if ((middleID = this.getImageID(this.middleTextField.getText())) != null) {
            BufferedImage middleImage = rotatedImage.getSubimage(topPoint.x, topPoint.y, cellSize.width, cellSize.height);
            splitImages.put(middleID, middleImage);
        }
        if ((bottomID = this.getImageID(this.bottomTextField.getText())) != null) {
            int topY = topPoint.y + cellSize.height;
            BufferedImage bottomImage = rotatedImage.getSubimage(topPoint.x, topY, cellSize.width, Math.min(rotatedImage.getHeight() - topY - 1, cellSize.height));
            splitImages.put(bottomID, bottomImage);
        }
        splitImages = this.correctImageDimensions(splitImages);
        this.alignmentPanel.setScanImages(splitImages);
        this.alignmentDialog.setLocationRelativeTo(this);
        this.alignmentDialog.setVisible(true);
    }

    private Map<Object, BufferedImage> correctImageDimensions(Map<Object, BufferedImage> cellImages) {
        HashMap<Object, BufferedImage> result = new HashMap<Object, BufferedImage>();
        RenderControl renderControl = RenderControl.getInstance();
        for (Map.Entry<Object, BufferedImage> entry : cellImages.entrySet()) {
            Object id = entry.getKey();
            BufferedImage cellImage = entry.getValue();
            RenderImage renderImage = null;
            try {
                renderImage = renderControl.getRenderImage(id, RenderControl.RenderCondition.NEVER);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (renderImage == null) {
                JOptionPane.showMessageDialog(this, "Image \"" + id + "\" not found.");
                continue;
            }
            BufferedImage fillImage = renderImage.getBaseImage();
            if (fillImage == null) {
                JOptionPane.showMessageDialog(this, "Image \"" + id + "\" is empty.");
                continue;
            }
            double widthOverHeight = (double)fillImage.getWidth() / (double)fillImage.getHeight();
            double cellMargin = (float)cellImage.getHeight() * LayerImagePrintable.CELL_MARGIN;
            double correctedHeight = (double)cellImage.getHeight() - 2.0 * cellMargin;
            double correctedWidth = correctedHeight * widthOverHeight;
            correctedWidth = Math.min(correctedWidth, (double)cellImage.getWidth() - cellMargin);
            BufferedImage corrected = cellImage.getSubimage((int)cellMargin, (int)cellMargin, (int)correctedWidth, (int)correctedHeight);
            result.put(id, corrected);
        }
        return result;
    }

    private Object getImageID(String stringForm) {
        if (ImageOutputLayerID.isWellFormedID(stringForm)) {
            return new ImageOutputLayerID(stringForm);
        }
        if (ImageOutputID.isWellFormedID(stringForm)) {
            return new ImageOutputID(stringForm);
        }
        return null;
    }
}

