/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scanimport;

import com.sodiumarc.patchwork.util.Rectangle4d;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class OffsetImage {
    private final BufferedImage image;
    private final int xOffset;
    private final int yOffset;

    public static <T extends OffsetImage> Rectangle getCombinedBounds(Iterable<T> images) {
        Rectangle4d totalBounds = null;
        for (OffsetImage image : images) {
            Rectangle4d imageBounds = image.getBounds4d();
            if (imageBounds == null) continue;
            if (totalBounds == null) {
                totalBounds = imageBounds;
                continue;
            }
            totalBounds.combine(imageBounds);
        }
        return totalBounds == null ? null : totalBounds.asAWTRectangle();
    }

    public OffsetImage(BufferedImage image, Point offset) {
        this(image, offset.x, offset.y);
    }

    public OffsetImage(BufferedImage image, int xOffset, int yOffset) {
        this.image = image;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public Point getOffset() {
        return new Point(this.xOffset, this.yOffset);
    }

    public Rectangle getBounds() {
        if (this.image == null) {
            return null;
        }
        return new Rectangle(this.xOffset, this.yOffset, this.image.getWidth(), this.image.getHeight());
    }

    public Rectangle4d getBounds4d() {
        if (this.image == null) {
            return null;
        }
        return new Rectangle4d(this.xOffset, this.yOffset, this.image.getWidth(), this.image.getHeight());
    }
}

