/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.scanimport;

import com.sodiumarc.patchwork.app.scanimport.AlignmentImagePanel;
import com.sodiumarc.patchwork.render.RenderResourceIO;
import com.sodiumarc.patchwork.render.control.RenderControl;
import com.sodiumarc.patchwork.render.control.RenderImage;
import com.sodiumarc.patchwork.sketch.SketchAsset;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class AlignmentPanel
extends JPanel {
    private JComboBox nameCombo;
    private AlignmentImagePanel imagePanel;
    private JButton saveButton;
    private final Map<String, BufferedImage> scanImages = new HashMap<String, BufferedImage>();
    private final Map<String, BufferedImage> fillImages = new HashMap<String, BufferedImage>();
    private final Map<String, BufferedImage> overlayImages = new HashMap<String, BufferedImage>();

    public AlignmentPanel() {
        super(new BorderLayout());
        this.nameCombo = new JComboBox();
        this.nameCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignmentPanel.this.updateImagePanel();
            }
        });
        this.imagePanel = new AlignmentImagePanel();
        this.saveButton = new JButton("Save");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AlignmentPanel.this.doSave();
            }
        });
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SwingUtilities.getRoot(AlignmentPanel.this).setVisible(false);
            }
        });
        this.add((Component)this.nameCombo, "North");
        this.add((Component)new JScrollPane(this.imagePanel), "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(this.saveButton);
        buttonPanel.add(closeButton);
        this.add((Component)buttonPanel, "South");
    }

    public void setScanImages(Map<Object, BufferedImage> scanImages) {
        this.scanImages.clear();
        for (Map.Entry<Object, BufferedImage> entry : scanImages.entrySet()) {
            this.scanImages.put(entry.getKey().toString(), entry.getValue());
        }
        this.nameCombo.setModel(new DefaultComboBoxModel<Object>(scanImages.keySet().toArray()));
        this.fillImages.clear();
        this.overlayImages.clear();
        RenderControl renderControl = RenderControl.getInstance();
        for (Object id : scanImages.keySet()) {
            RenderImage renderImage = null;
            String name = id.toString();
            try {
                renderImage = renderControl.getRenderImage(id, RenderControl.RenderCondition.NEVER);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (renderImage == null) continue;
            BufferedImage fillImage = renderImage.getImage();
            this.fillImages.put(name, fillImage);
            SketchAsset asset = new SketchAsset(id.toString(), scanImages.get(id), 1.0f, 1.0f);
            BufferedImage overlayImage = asset.makeSplotchImage(Color.BLACK, true);
            this.overlayImages.put(name, overlayImage);
        }
        this.updateImagePanel();
    }

    private void doSave() {
        RenderResourceIO resourceIO = RenderResourceIO.getInstance();
        for (String name : this.overlayImages.keySet()) {
            try {
                resourceIO.writeOutputImage(this.overlayImages.get(name), resourceIO.getProcessedScanDir(), name);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Error writing file");
                e.printStackTrace();
            }
        }
    }

    private void updateImagePanel() {
        Object id = this.nameCombo.getSelectedItem();
        this.imagePanel.setImage(this.fillImages.get(id.toString()));
        this.imagePanel.setOverLayImage(this.overlayImages.get(id.toString()));
    }
}

