/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.pipeline;

import com.sodiumarc.patchwork.app.pipeline.LayerImagePrintable;
import com.sodiumarc.patchwork.render.control.RenderControl;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class PrintControl {
    public static final int IMAGES_PER_PAGE = 3;
    private final ExecutorService appThread;

    public PrintControl(ExecutorService appThread, RenderControl renderControl) {
        this.appThread = appThread;
    }

    public void printLayerImages(List<Object> imageIDs) {
        final PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(new LayerImagePrintable(imageIDs, 3));
        boolean ok = job.printDialog();
        if (ok) {
            this.appThread.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        job.print();
                    }
                    catch (PrinterException ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
    }
}

