/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.pipeline;

import com.sodiumarc.patchwork.app.ApplicationProperties;
import com.sodiumarc.patchwork.app.pipeline.ImageDisplayPanel;
import com.sodiumarc.patchwork.app.pipeline.InputSceneTree;
import com.sodiumarc.patchwork.app.pipeline.PrintControl;
import com.sodiumarc.patchwork.generate.GeneratorControl;
import com.sodiumarc.patchwork.generate.GeneratorProgressObserver;
import com.sodiumarc.patchwork.render.RenderQuality;
import com.sodiumarc.patchwork.render.control.ImageOutputID;
import com.sodiumarc.patchwork.render.control.ImageOutputLayerID;
import com.sodiumarc.patchwork.render.control.RenderControl;
import com.sodiumarc.patchwork.render.control.RenderProgressObserver;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class PipelineApp
extends JFrame {
    public static String TITLE = "Pipeline Application";
    private JButton renderButton;
    private JButton updateButton;
    private JButton generateButton;
    private JButton printButton;
    private JCheckBox propertiesOnlyCheck;
    private JComboBox qualityCombo;
    private JProgressBar totalProgressBar;
    private JProgressBar secondaryProgressBar;
    private ImageDisplayPanel imagePanel;
    private InputSceneTree sceneTree;
    private JList cardList;
    private final Set<ImageOutputLayerID> renderingLayerIDs;
    private Object lastRendereredID;
    private boolean isGenerating = false;
    private final ExecutorService appThread;
    private final RenderControl renderControl;
    private final GeneratorControl generatorControl;
    private final PrintControl printControl;
    private final RenderProgressObserver renderProgressObserver = new RenderProgressObserver(){

        @Override
        public void imageRenderStarted(final ImageOutputLayerID id) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PipelineApp.this.onRenderImageStarted(id);
                }
            });
        }

        @Override
        public void imageRenderStarted(final ImageOutputID id) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PipelineApp.this.onRenderImageStarted(id);
                }
            });
        }

        @Override
        public void imageRenderComplete(final ImageOutputLayerID id) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PipelineApp.this.onRenderImageComplete(id);
                }
            });
        }

        @Override
        public void imageRenderComplete(final ImageOutputID id) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PipelineApp.this.onRenderImageComplete(id);
                }
            });
        }

        @Override
        public void objectRenderComplete(final String objectID, final int objectIndex, final int totalObjectCount) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PipelineApp.this.onRenderObjectComplete(objectID, objectIndex, totalObjectCount);
                }
            });
        }

        @Override
        public void objectRenderStarted(final String objectID, final int objectIndex, final int totalObjectCount) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PipelineApp.this.onRenderObjectStarted(objectID, objectIndex, totalObjectCount);
                }
            });
        }
    };
    private GeneratorProgressObserver generatorProgressObserver = new GeneratorProgressObserver(){

        @Override
        public void cardGenerationStarted(final String cardID, final int cardIndex, final int totalCardCount) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PipelineApp.this.onGenerationStarted(cardID, cardIndex, totalCardCount);
                }
            });
        }

        @Override
        public void cardGenerationComplete(final String cardID, final int cardIndex, final int totalCardCount) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PipelineApp.this.onGenerationComplete(cardID, cardIndex, totalCardCount);
                }
            });
        }
    };

    public static void main(String[] args) {
        ApplicationProperties.load();
        ApplicationProperties.parseArgs(args);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new PipelineApp();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public PipelineApp() throws HeadlessException {
        super(TITLE);
        this.renderingLayerIDs = new HashSet<ImageOutputLayerID>();
        this.appThread = Executors.newSingleThreadExecutor();
        this.renderControl = RenderControl.getInstance();
        this.generatorControl = GeneratorControl.getInstance();
        this.printControl = new PrintControl(this.appThread, this.renderControl);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                PipelineApp.this.exit();
            }
        });
        this.setContentPane(this.createContentPane());
        this.updateButtonEnabling();
        this.appThread.submit(new Runnable(){

            @Override
            public void run() {
                PipelineApp.this.renderControl.addRenderProgressObserver(PipelineApp.this.renderProgressObserver);
                try {
                    ArrayList<String> cardIDs = new ArrayList<String>(PipelineApp.this.generatorControl.getCardIDs());
                    Collections.sort(cardIDs);
                    PipelineApp.this.cardList.setListData(cardIDs.toArray());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.pack();
        this.setSize(new Dimension(700, 600));
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private JComponent createContentPane() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createMainPanel(), "Center");
        panel.add((Component)this.createButtonPanel(), "South");
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return panel;
    }

    private JComponent createMainPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 2));
        this.sceneTree = new InputSceneTree(this.appThread, this.renderControl);
        this.sceneTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PipelineApp.this.onTreeSelectionChanged();
            }
        });
        JScrollPane treeScroller = new JScrollPane(this.sceneTree);
        this.addTitleBorder(treeScroller, "Input Scenes");
        this.cardList = new JList();
        this.cardList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PipelineApp.this.onListSelectionChanged();
            }
        });
        this.cardList.setVisibleRowCount(4);
        JScrollPane listScroller = new JScrollPane(this.cardList);
        this.addTitleBorder(listScroller, "Cards");
        JPanel treeAndListPanel = new JPanel(new BorderLayout());
        treeAndListPanel.add((Component)treeScroller, "Center");
        treeAndListPanel.add((Component)listScroller, "South");
        panel.add(treeAndListPanel);
        panel.add(this.createRenderStatusPanel());
        return panel;
    }

    private JComponent createRenderStatusPanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 10));
        this.imagePanel = new ImageDisplayPanel(this.appThread, this.renderControl);
        this.addTitleBorder(this.imagePanel, "Output Image");
        JPanel progressBarPanel = new JPanel(new GridLayout(2, 1, 10, 10));
        this.totalProgressBar = new JProgressBar();
        this.totalProgressBar.setStringPainted(true);
        this.totalProgressBar.setString("");
        this.totalProgressBar.setEnabled(false);
        this.secondaryProgressBar = new JProgressBar();
        this.secondaryProgressBar.setStringPainted(true);
        this.secondaryProgressBar.setString("");
        this.secondaryProgressBar.setEnabled(false);
        progressBarPanel.add(this.totalProgressBar);
        progressBarPanel.add(this.secondaryProgressBar);
        this.addTitleBorder(progressBarPanel, "Progress");
        JComponent settingsPanel = this.createRenderSettingsPanel();
        JPanel bottomPanel = new JPanel(new BorderLayout(0, 10));
        bottomPanel.add((Component)settingsPanel, "Center");
        bottomPanel.add((Component)progressBarPanel, "South");
        panel.add((Component)this.imagePanel, "Center");
        panel.add((Component)bottomPanel, "South");
        return panel;
    }

    private JComponent createRenderSettingsPanel() {
        this.propertiesOnlyCheck = new JCheckBox();
        this.qualityCombo = new JComboBox<RenderQuality>(RenderQuality.values());
        this.qualityCombo.setSelectedItem((Object)RenderQuality.MODERATE);
        JPanel panel = new JPanel(new GridLayout(2, 2, 10, 5));
        JLabel label = new JLabel("Quality:");
        label.setHorizontalAlignment(4);
        panel.add(label);
        panel.add(this.qualityCombo);
        label = new JLabel("Properties Only:");
        label.setHorizontalAlignment(4);
        panel.add(label);
        panel.add(this.propertiesOnlyCheck);
        this.addTitleBorder(panel, "Render Settings", 5);
        return panel;
    }

    private JComponent createButtonPanel() {
        this.updateButton = new JButton("Update");
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PipelineApp.this.beginRendering(RenderControl.RenderCondition.IF_NOT_CURRENT);
            }
        });
        this.renderButton = new JButton("Render");
        this.renderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PipelineApp.this.beginRendering(RenderControl.RenderCondition.ALWAYS);
            }
        });
        this.generateButton = new JButton("Generate");
        this.generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PipelineApp.this.beginGenerating();
            }
        });
        this.printButton = new JButton("Print");
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PipelineApp.this.beginPrinting();
            }
        });
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PipelineApp.this.exit();
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(this.updateButton);
        buttonPanel.add(this.renderButton);
        buttonPanel.add(this.printButton);
        buttonPanel.add(this.generateButton);
        buttonPanel.add(closeButton);
        return buttonPanel;
    }

    private void addTitleBorder(JComponent component, String title) {
        this.addTitleBorder(component, title, 0);
    }

    private void addTitleBorder(JComponent component, String title, int interiorMargin) {
        Border margin = BorderFactory.createEmptyBorder(interiorMargin, interiorMargin, interiorMargin, interiorMargin);
        TitledBorder titleBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title, 1, 1);
        component.setBorder(BorderFactory.createCompoundBorder(titleBorder, margin));
    }

    private void updateImagePanel() {
        Set<ImageOutputID> imageOutputIDs = this.sceneTree.getSelectedImageOutputs();
        Set<ImageOutputLayerID> layerIDs = this.sceneTree.getSelectedLayers();
        if (imageOutputIDs.size() == 1 && layerIDs.size() == 0) {
            this.imagePanel.showImage(CollectionUtils.first(imageOutputIDs));
        } else if (imageOutputIDs.size() == 0 && layerIDs.size() == 1) {
            this.imagePanel.showImage(CollectionUtils.first(layerIDs));
        } else if (this.lastRendereredID instanceof ImageOutputID) {
            this.imagePanel.showImage((ImageOutputID)this.lastRendereredID);
        } else if (this.lastRendereredID instanceof ImageOutputLayerID) {
            this.imagePanel.showImage((ImageOutputLayerID)this.lastRendereredID);
        }
    }

    private void updateButtonEnabling() {
        boolean validTreeSelection = !this.sceneTree.getSelectedLayers().isEmpty() || !this.sceneTree.getSelectedImageOutputs().isEmpty();
        boolean renderEnabled = !this.isRendering() && !this.isGenerating && validTreeSelection;
        this.renderButton.setEnabled(renderEnabled);
        this.updateButton.setEnabled(renderEnabled);
        this.printButton.setEnabled(validTreeSelection);
        boolean validCardSelection = this.cardList.getSelectedValues().length > 0;
        this.generateButton.setEnabled(!this.isRendering() && !this.isGenerating && validCardSelection);
    }

    private void onTreeSelectionChanged() {
        this.updateButtonEnabling();
        this.updateImagePanel();
    }

    private void onListSelectionChanged() {
        this.updateButtonEnabling();
    }

    private void beginRendering(final RenderControl.RenderCondition renderCondition) {
        assert (this.renderingLayerIDs.isEmpty()) : "renderingLayerIDs not empty";
        boolean propertiesOnly = this.propertiesOnlyCheck.isSelected();
        this.beginProgressReporting(this.totalProgressBar, 0, this.renderingLayerIDs.size());
        this.secondaryProgressBar.setString("");
        this.updateButtonEnabling();
        final ArrayList<ImageOutputID> imagesToRender = new ArrayList<ImageOutputID>(this.sceneTree.getSelectedImageOutputs());
        final ArrayList<ImageOutputLayerID> layersToRender = new ArrayList<ImageOutputLayerID>(this.sceneTree.getSelectedLayers());
        this.appThread.submit(new Runnable(){

            @Override
            public void run() {
                final HashSet allLayers = new HashSet();
                allLayers.addAll(layersToRender);
                try {
                    if (renderCondition == RenderControl.RenderCondition.IF_NOT_CURRENT) {
                        Iterator iter = allLayers.iterator();
                        while (iter.hasNext()) {
                            if (!PipelineApp.this.renderControl.isRenderImageCurrent((ImageOutputLayerID)iter.next())) continue;
                            iter.remove();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (allLayers.isEmpty() && imagesToRender.isEmpty()) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PipelineApp.this.renderingLayerIDs.addAll(allLayers);
                    }
                });
                for (Comparable<ImageOutputLayerID> id : allLayers) {
                    try {
                        PipelineApp.this.renderControl.getRenderImage((ImageOutputLayerID)id, renderCondition);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        return;
                    }
                }
                for (Comparable<ImageOutputLayerID> id : imagesToRender) {
                    try {
                        PipelineApp.this.renderControl.getRenderImage((ImageOutputID)id, renderCondition);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        return;
                    }
                }
            }
        });
    }

    private void beginGenerating() {
        final ArrayList<String> cardFilenames = new ArrayList<String>();
        for (Object selection : this.cardList.getSelectedValues()) {
            cardFilenames.add((String)selection);
        }
        if (cardFilenames.isEmpty()) {
            return;
        }
        this.secondaryProgressBar.setString("");
        this.isGenerating = true;
        this.updateButtonEnabling();
        this.appThread.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    PipelineApp.this.generatorControl.generate(cardFilenames, PipelineApp.this.generatorProgressObserver);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return;
                }
            }
        });
    }

    private void beginPrinting() {
        ArrayList<Object> toPrint = new ArrayList<Object>();
        toPrint.addAll(this.sceneTree.getSelectedLayers());
        toPrint.addAll(this.sceneTree.getSelectedImageOutputs());
        this.printControl.printLayerImages(toPrint);
    }

    private void onRenderImageStarted(ImageOutputLayerID id) {
        if (!this.isRendering()) {
            return;
        }
        this.beginProgressChunk(this.totalProgressBar, id.toString());
    }

    private void onRenderImageComplete(ImageOutputLayerID id) {
        if (!this.isRendering()) {
            return;
        }
        this.renderingLayerIDs.remove(id);
        this.lastRendereredID = id;
        this.endProgressChunk(this.totalProgressBar, this.renderingLayerIDs.size());
        if (this.renderingLayerIDs.isEmpty()) {
            this.endProgressReporting(this.totalProgressBar);
        }
        this.updateButtonEnabling();
        this.imagePanel.reloadImage(id);
    }

    private void onRenderImageStarted(ImageOutputID id) {
    }

    private void onRenderImageComplete(ImageOutputID id) {
        this.imagePanel.reloadImage(id);
    }

    private void onRenderObjectStarted(String objectID, int objectIndex, int totalObjectCount) {
        if (objectIndex == 0) {
            this.beginProgressReporting(this.secondaryProgressBar, 0, totalObjectCount);
        }
        this.beginProgressChunk(this.secondaryProgressBar, objectID);
    }

    private void onRenderObjectComplete(String objectID, int objectIndex, int totalObjectCount) {
        this.endProgressChunk(this.secondaryProgressBar, objectIndex + 1);
        if (objectIndex == totalObjectCount - 1) {
            this.endProgressReporting(this.secondaryProgressBar);
        }
    }

    private void onGenerationStarted(String cardID, int cardIndex, int totalCardCount) {
        if (cardIndex == 0) {
            this.beginProgressReporting(this.totalProgressBar, 0, totalCardCount);
        }
        this.beginProgressChunk(this.totalProgressBar, cardID);
    }

    private void onGenerationComplete(String cardID, int cardIndex, int totalCardCount) {
        this.endProgressChunk(this.totalProgressBar, cardIndex + 1);
        if (cardIndex == totalCardCount - 1) {
            this.endProgressReporting(this.totalProgressBar);
            this.isGenerating = false;
            this.updateButtonEnabling();
        }
    }

    private void beginProgressReporting(JProgressBar bar, int min, int max) {
        bar.setString("");
        bar.setMinimum(min);
        bar.setMaximum(max);
        bar.setEnabled(true);
    }

    private void beginProgressChunk(JProgressBar bar, String chunkDescription) {
        bar.setString(chunkDescription);
    }

    private void endProgressChunk(JProgressBar bar, int chunksComplete) {
        bar.setString("");
        bar.setValue(chunksComplete);
    }

    private void endProgressReporting(JProgressBar bar) {
        bar.setString("Done");
        bar.setMinimum(0);
        bar.setMaximum(0);
        bar.setValue(0);
        bar.setEnabled(false);
    }

    private boolean isRendering() {
        return !this.renderingLayerIDs.isEmpty();
    }

    private void exit() {
        this.appThread.shutdownNow();
        System.exit(0);
    }
}

