/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.pipeline;

import com.sodiumarc.patchwork.render.control.ImageOutputID;
import com.sodiumarc.patchwork.render.control.ImageOutputLayerID;
import com.sodiumarc.patchwork.render.control.InputSceneID;
import com.sodiumarc.patchwork.render.control.RenderControl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class InputSceneTreeModel
extends DefaultTreeModel {
    private final ExecutorService appThread;
    private final RenderControl renderControl;
    private static final Object DUMMY_CHILD = "Loading...";

    public InputSceneTreeModel(ExecutorService appThread, RenderControl renderControl) {
        super(new DefaultMutableTreeNode("<ROOT>"));
        this.appThread = appThread;
        this.renderControl = renderControl;
    }

    public Set<ImageOutputLayerID> getLayerIDs(TreePath[] paths) {
        if (paths == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<ImageOutputLayerID> resultSet = new LinkedHashSet<ImageOutputLayerID>();
        for (TreePath treePath : paths) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object userObject = treeNode.getUserObject();
            if (!(userObject instanceof ImageOutputLayerID)) continue;
            resultSet.add((ImageOutputLayerID)userObject);
        }
        return resultSet;
    }

    public Set<ImageOutputID> getImageOutputIDs(TreePath[] paths) {
        if (paths == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<ImageOutputID> resultSet = new LinkedHashSet<ImageOutputID>();
        for (TreePath treePath : paths) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object userObject = treeNode.getUserObject();
            if (!(userObject instanceof ImageOutputID)) continue;
            resultSet.add((ImageOutputID)userObject);
        }
        return new HashSet<ImageOutputID>(resultSet);
    }

    void initRoots() {
        this.appThread.submit(new Runnable(){

            @Override
            public void run() {
                final HashSet<InputSceneID> sceneIDs = new HashSet<InputSceneID>();
                try {
                    sceneIDs.addAll(InputSceneTreeModel.this.renderControl.getSceneIDs());
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass()).warn("Failed to get scene IDs", e);
                    e.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        InputSceneTreeModel.this.setRoots(sceneIDs);
                    }
                });
            }
        });
    }

    void initChildren(TreePath path) {
        final DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (!this.hasDummyChild(node)) {
            return;
        }
        final Object userObject = node.getUserObject();
        this.appThread.submit(new Runnable(){

            @Override
            public void run() {
                final ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>();
                try {
                    if (userObject instanceof InputSceneID) {
                        for (ImageOutputID id : InputSceneTreeModel.this.renderControl.getImageOutputIDs((InputSceneID)userObject, false)) {
                            children.add(InputSceneTreeModel.this.newUnloadedNode(id));
                        }
                    } else if (userObject instanceof ImageOutputID) {
                        for (ImageOutputLayerID id : InputSceneTreeModel.this.renderControl.getLayerIDs((ImageOutputID)userObject)) {
                            children.add(InputSceneTreeModel.this.newUnloadedNode(id));
                        }
                    } else if (userObject instanceof ImageOutputLayerID) {
                        ImageOutputLayerID layerID = (ImageOutputLayerID)userObject;
                        for (long frameTime : InputSceneTreeModel.this.renderControl.getFrameTimes(layerID)) {
                            children.add(new DefaultMutableTreeNode(new ImageOutputLayerID(layerID.getImageOutputID(), layerID.getLayerID(), frameTime)));
                        }
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(InputSceneTreeModel.class).warn("Failed to load tree data: " + e);
                    e.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        InputSceneTreeModel.this.setChildren(node, children);
                    }
                });
            }
        });
    }

    private void setRoots(Set<InputSceneID> sceneIDs) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        for (InputSceneID id : sceneIDs) {
            root.add(this.newUnloadedNode(id));
        }
        this.nodeStructureChanged(root);
    }

    private void setChildren(DefaultMutableTreeNode parent, List<DefaultMutableTreeNode> children) {
        parent.removeAllChildren();
        Collections.sort(children, new Comparator<DefaultMutableTreeNode>(){

            @Override
            public int compare(DefaultMutableTreeNode node0, DefaultMutableTreeNode node1) {
                Comparable c0 = (Comparable)node0.getUserObject();
                Comparable c1 = (Comparable)node1.getUserObject();
                return c0.compareTo(c1);
            }
        });
        int[] indices = new int[children.size()];
        int i = 0;
        for (DefaultMutableTreeNode child : children) {
            parent.add(child);
            indices[i] = i++;
        }
        this.nodeStructureChanged(parent);
    }

    private DefaultMutableTreeNode newUnloadedNode(Object data) {
        DefaultMutableTreeNode result = new DefaultMutableTreeNode(data);
        result.add(new DefaultMutableTreeNode(DUMMY_CHILD));
        return result;
    }

    private boolean hasDummyChild(DefaultMutableTreeNode node) {
        if (node.getChildCount() != 1) {
            return false;
        }
        DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(0);
        return child.getUserObject() == DUMMY_CHILD;
    }
}

