/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.pipeline;

import com.sodiumarc.patchwork.app.pipeline.InputSceneTreeModel;
import com.sodiumarc.patchwork.render.control.ImageOutputID;
import com.sodiumarc.patchwork.render.control.ImageOutputLayerID;
import com.sodiumarc.patchwork.render.control.RenderControl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class InputSceneTree
extends JTree {
    private final Set<ImageOutputID> renderingImageIDs = new HashSet<ImageOutputID>();
    private final Set<ImageOutputLayerID> renderingLayerIDs = new HashSet<ImageOutputLayerID>();

    public InputSceneTree(ExecutorService appThread, RenderControl renderControl) {
        this.setModel(new InputSceneTreeModel(appThread, renderControl));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setCellRenderer(new InputSceneTreeRenderer());
        this.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                InputSceneTree.this.onExpand(event.getPath());
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                InputSceneTree.this.onCollapse(event.getPath());
            }
        });
        ((InputSceneTreeModel)this.getModel()).initRoots();
    }

    public void setRendering(ImageOutputID imageOutputID, boolean isRendering) {
        if (isRendering) {
            this.renderingImageIDs.add(imageOutputID);
        } else {
            this.renderingImageIDs.remove(imageOutputID);
        }
        this.repaint();
    }

    public void setRendering(ImageOutputLayerID layerID, boolean isRendering) {
        if (isRendering) {
            this.renderingLayerIDs.add(layerID);
        } else {
            this.renderingLayerIDs.remove(layerID);
        }
        this.repaint();
    }

    public Set<ImageOutputID> getSelectedImageOutputs() {
        return ((InputSceneTreeModel)this.getModel()).getImageOutputIDs(this.getSelectionPaths());
    }

    public Set<ImageOutputLayerID> getSelectedLayers() {
        return ((InputSceneTreeModel)this.getModel()).getLayerIDs(this.getSelectionPaths());
    }

    private void onExpand(TreePath path) {
        ((InputSceneTreeModel)this.getModel()).initChildren(path);
    }

    private void onCollapse(TreePath path) {
    }

    private class InputSceneTreeRenderer
    extends DefaultTreeCellRenderer {
        private InputSceneTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component component = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (component instanceof JLabel && value instanceof DefaultMutableTreeNode) {
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                JLabel label = (JLabel)component;
                Color textColor = Color.BLACK;
                Font font = tree.getFont();
                if (InputSceneTree.this.renderingImageIDs.contains(userObject) || InputSceneTree.this.renderingLayerIDs.contains(userObject)) {
                    font = new Font(font.getName(), 2, font.getSize());
                }
                if (userObject instanceof String) {
                    label.setIcon(null);
                } else if (userObject instanceof ImageOutputLayerID) {
                    ImageOutputLayerID layerID = (ImageOutputLayerID)userObject;
                    long frameTime = layerID.getFrameTime();
                    if (frameTime < 0L) {
                        label.setText(layerID.getLayerID());
                    } else {
                        label.setText(layerID.getLayerID() + " [" + frameTime + "]");
                    }
                }
                label.setForeground(textColor);
                label.setFont(font);
            }
            return component;
        }
    }
}

