/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.layeredimage;

import com.sodiumarc.patchwork.app.icon.IconLoader;
import com.sodiumarc.patchwork.app.layeredimage.ImageLayer;
import com.sodiumarc.patchwork.render.control.KnownImageFilter;
import com.sodiumarc.patchwork.util.LabeledRowPanel;
import com.sodiumarc.patchwork.util.TargetablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ImageLayerPanel
extends TargetablePanel<ImageLayer> {
    private JComboBox layerNameCombo = new JComboBox();
    private ActionListener layerNameFieldListener;
    private JList layerList;
    private JButton addButton;
    private JButton deleteButton;
    private JButton promoteButton;
    private JButton demoteButton;
    private JComboBox addCombo;

    public ImageLayerPanel(List<String> layerNameOptions) {
        super(new BorderLayout(0, 10));
        if (layerNameOptions != null) {
            ArrayList<String> elements = new ArrayList<String>(layerNameOptions);
            elements.add(0, null);
            this.layerNameCombo.setModel(new DefaultComboBoxModel<Object>(elements.toArray()));
            this.layerNameCombo.setEditable(false);
        } else {
            this.layerNameCombo.setModel(new DefaultComboBoxModel());
            this.layerNameCombo.setEditable(true);
        }
        this.layerNameCombo.setEnabled(false);
        this.layerNameFieldListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageLayer target = (ImageLayer)ImageLayerPanel.this.getTarget();
                if (target != null) {
                    String name = (String)ImageLayerPanel.this.layerNameCombo.getSelectedItem();
                    target.setName(name);
                    ImageLayerPanel.this.fireTargetModified();
                }
            }
        };
        this.setBorder(BorderFactory.createTitledBorder("Layer Settings"));
        ArrayList<LabeledRowPanel.LabeledRow> rows = new ArrayList<LabeledRowPanel.LabeledRow>();
        rows.add(new LabeledRowPanel.LabeledRow("Name", (Component)this.layerNameCombo, true));
        this.add((Component)new LabeledRowPanel(rows), "North");
        this.add(this.makeFilterListPanel(), "Center");
        this.updateControlEnabling();
    }

    @Override
    protected void targetSet() {
        ImageLayer target = (ImageLayer)this.getTarget();
        this.layerNameCombo.removeActionListener(this.layerNameFieldListener);
        if (target != null) {
            this.layerNameCombo.setSelectedItem(target.getName());
            this.layerNameCombo.setEnabled(true);
        } else {
            this.layerNameCombo.setSelectedItem(null);
            this.layerNameCombo.setEnabled(false);
        }
        this.layerNameCombo.addActionListener(this.layerNameFieldListener);
    }

    private Component makeFilterListPanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        this.layerList = new JList();
        this.layerList.setVisibleRowCount(4);
        this.layerList.setSelectionMode(0);
        this.layerList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ImageLayerPanel.this.onFilterSelection();
            }
        });
        final Icon layerIcon = IconLoader.loadIcon("silk/image.png");
        this.layerList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (component instanceof JLabel) {
                    JLabel label = (JLabel)component;
                    label.setIcon(layerIcon);
                }
                return component;
            }
        });
        JPanel buttonPanel = new JPanel(new BorderLayout(2, 2));
        JPanel buttonPanelRight = new JPanel(new GridLayout(1, 3));
        this.addButton = new JButton(IconLoader.loadIcon("silk/brick_add.png"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImageLayerPanel.this.onAddFilter();
            }
        });
        buttonPanel.add((Component)this.addButton, "West");
        this.addCombo = new JComboBox<KnownImageFilter>(KnownImageFilter.values());
        buttonPanel.add((Component)this.addCombo, "Center");
        this.deleteButton = new JButton(IconLoader.loadIcon("silk/brick_delete.png"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImageLayerPanel.this.onDeleteFilter();
            }
        });
        buttonPanelRight.add(this.deleteButton);
        this.promoteButton = new JButton(IconLoader.loadIcon("silk/arrow_up.png"));
        this.promoteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImageLayerPanel.this.onPromoteFilter();
            }
        });
        buttonPanelRight.add(this.promoteButton);
        this.demoteButton = new JButton(IconLoader.loadIcon("silk/arrow_down.png"));
        this.demoteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImageLayerPanel.this.onDemoteFilter();
            }
        });
        buttonPanelRight.add(this.demoteButton);
        buttonPanel.add((Component)buttonPanelRight, "East");
        panel.add((Component)new JScrollPane(this.layerList), "Center");
        panel.add((Component)buttonPanel, "South");
        return panel;
    }

    private void onDemoteFilter() {
    }

    private void onPromoteFilter() {
    }

    private void onDeleteFilter() {
    }

    private void onAddFilter() {
    }

    private void onFilterSelection() {
    }

    private void updateControlEnabling() {
    }
}

