/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.layeredimage;

import com.sodiumarc.patchwork.app.scenecomposer.model.ConfiguredImageFilter;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.CompareUtilities;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import com.sodiumarc.patchwork.util.xml.SimpleTranscoder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImageLayer {
    private String name;
    private File sourceImageFile;
    private BufferedImage sourceImage;
    private BufferedImage sourceImageCropped;
    private Rectangle4d sourceImageRect;
    private boolean sourceRectIsProportional;
    private List<ConfiguredImageFilter> filters = new ArrayList<ConfiguredImageFilter>();
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private ImageLoader imageLoader;
    private boolean fileNotFound;

    public ImageLayer(File inputImageFile) {
        this.sourceImageFile = inputImageFile;
        this.imageLoader = new ImageLoader(){

            @Override
            public BufferedImage loadImage(ImageLayer layer, File file) {
                try {
                    return ImageIO.read(ImageLayer.this.sourceImageFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            public boolean imageExists(ImageLayer layer, File file) {
                return file.exists();
            }
        };
    }

    public ImageLayer(String name, File inputImageFile) {
        this(inputImageFile);
        this.name = name;
    }

    public ImageLoader getImageLoader() {
        return this.imageLoader;
    }

    public void setImageLoader(ImageLoader imageLoader) {
        assert (imageLoader != null) : "image loader is null";
        this.imageLoader = imageLoader;
    }

    public void setName(String name) {
        if (!CompareUtilities.equals(this.name, name)) {
            this.name = name;
            this.sourceImage = null;
            this.sourceImageCropped = null;
            this.fireChanged();
        }
    }

    public String getName() {
        return this.name;
    }

    public final BufferedImage getSourceImage() {
        if (this.sourceImage == null) {
            if (this.sourceImageFile != null && this.imageLoader.imageExists(this, this.sourceImageFile)) {
                this.sourceImage = this.imageLoader.loadImage(this, this.sourceImageFile);
            } else {
                this.fileNotFound = true;
            }
        }
        return this.sourceImage;
    }

    public final BufferedImage getSourceImageCropped() {
        BufferedImage uncropped = this.getSourceImage();
        if (this.sourceImageRect == null) {
            return uncropped;
        }
        if (this.sourceImageCropped == null) {
            Rectangle4d pixelRectUncropped = new Rectangle4d(0.0, 0.0, uncropped.getWidth(), uncropped.getHeight());
            Rectangle4d pixelRect = this.sourceRectIsProportional ? pixelRectUncropped.fromProportional(this.sourceImageRect) : this.sourceImageRect;
            this.sourceImageCropped = ImageUtils.safeSubimage(uncropped, (int)pixelRect.getX(), (int)pixelRect.getY(), (int)pixelRect.getWidth(), (int)pixelRect.getHeight());
        }
        return this.sourceImageCropped;
    }

    public boolean isEmpty() {
        return this.getSourceImage() == null;
    }

    public final void setSourceImageFile(File inputImageFile) {
        assert (inputImageFile != null);
        if (!this.sourceImageFile.equals(inputImageFile)) {
            this.sourceImageFile = inputImageFile;
            this.sourceImage = null;
            this.fileNotFound = false;
            this.fireChanged();
        }
    }

    public final File getSourceImageFile() {
        return this.sourceImageFile;
    }

    public Rectangle4d getSourceImageRect() {
        return this.sourceImageRect;
    }

    public void setSourceImageRect(Rectangle4d sourceImageRect, boolean isProportional) {
        if (!CompareUtilities.equals(this.sourceImageRect, sourceImageRect) || this.sourceRectIsProportional != isProportional) {
            this.sourceImageRect = sourceImageRect;
            this.sourceRectIsProportional = isProportional;
            this.sourceImageCropped = null;
            this.fireChanged();
        }
    }

    public final BufferedImage getProcessedImage() {
        BufferedImage result = this.getSourceImageCropped();
        for (ConfiguredImageFilter filter : this.filters) {
            result = filter.apply(result);
        }
        return result;
    }

    public void addFilter(ConfiguredImageFilter filter) {
        this.filters.add(filter);
        this.fireChanged();
    }

    public void removeFilter(ConfiguredImageFilter filter) {
        this.filters.remove(filter);
        this.fireChanged();
    }

    public void promoteFilter(ConfiguredImageFilter filter) {
        int oldIndex = this.filters.indexOf(filter);
        if (oldIndex < 0 || oldIndex == this.filters.size() - 1) {
            return;
        }
        this.filters.remove(filter);
        this.filters.add(oldIndex + 1, filter);
        this.fireChanged();
    }

    public void demoteFilter(ConfiguredImageFilter filter) {
        int oldIndex = this.filters.indexOf(filter);
        if (oldIndex <= 0) {
            return;
        }
        this.filters.remove(filter);
        this.filters.add(oldIndex - 1, filter);
        this.fireChanged();
    }

    public boolean isFileNotFound() {
        return this.fileNotFound;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void refresh() {
        this.sourceImage = null;
        this.sourceImageCropped = null;
        this.fileNotFound = false;
    }

    public String toString() {
        String result = this.sourceImageFile.getName();
        if (this.name != null) {
            result = "(" + this.name + ") " + result;
        }
        return result;
    }

    private void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener listener : new ArrayList<ChangeListener>(this.changeListeners)) {
            listener.stateChanged(changeEvent);
        }
    }

    public static class Transcoder
    extends SimpleTranscoder<ImageLayer> {
        private static final String ELEMENT_NAME = "ImageLayer";
        private static final String ATTR_NAME = "name";
        private static final String ATTR_INPUT_FILENAME = "inputFilename";
        private static final String ATTR_SOURCE_RECT = "sourceRect";
        private static final String ATTR_SOURCE_RECT_IS_PROPORTIONAL = "sourceRectIsProportional";
        private static final String FIELD_CONFIGURED_FILTERS = "configuredFilters";

        public Transcoder() {
            super(ELEMENT_NAME, ImageLayer.class);
            this.setFieldTranscoder(FIELD_CONFIGURED_FILTERS, new ConfiguredImageFilter.Transcoder());
        }

        @Override
        protected ImageLayer decode(Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            ImageLayer result = new ImageLayer(new File(attributes.get(ATTR_INPUT_FILENAME)));
            result.name = attributes.get(ATTR_NAME);
            for (Object filter : decodedChildren.getAll(FIELD_CONFIGURED_FILTERS)) {
                result.filters.add((ConfiguredImageFilter)filter);
            }
            if (attributes.containsKey(ATTR_SOURCE_RECT)) {
                result.sourceImageRect = new Rectangle4d(attributes.get(ATTR_SOURCE_RECT));
            }
            if (attributes.containsKey(ATTR_SOURCE_RECT_IS_PROPORTIONAL)) {
                result.sourceRectIsProportional = Boolean.valueOf(attributes.get(ATTR_SOURCE_RECT_IS_PROPORTIONAL));
            }
            return result;
        }

        @Override
        protected void getAttributes(ImageLayer object, Map<String, String> destination) {
            destination.put(ATTR_INPUT_FILENAME, object.sourceImageFile.getPath());
            destination.put(ATTR_NAME, object.getName());
            if (object.sourceImageRect != null) {
                destination.put(ATTR_SOURCE_RECT, object.sourceImageRect.encode());
            }
            destination.put(ATTR_SOURCE_RECT_IS_PROPORTIONAL, Boolean.toString(object.sourceRectIsProportional));
        }

        @Override
        protected void getChildren(ImageLayer object, MultiMap<String, Object> destination) {
            for (ConfiguredImageFilter filter : object.filters) {
                destination.putLast(FIELD_CONFIGURED_FILTERS, filter);
            }
        }
    }

    public static interface ImageLoader {
        public boolean imageExists(ImageLayer var1, File var2);

        public BufferedImage loadImage(ImageLayer var1, File var2);
    }
}

