/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.animimport;

import com.sodiumarc.patchwork.FileUtils;
import com.sodiumarc.patchwork.animation.SpriteSheet;
import com.sodiumarc.patchwork.app.animimport.ScanAdjustmentPanel;
import com.sodiumarc.patchwork.app.common.FooterButtonPanel;
import com.sodiumarc.patchwork.app.common.ScrollableImagePanel;
import com.sodiumarc.patchwork.generate.Card;
import com.sodiumarc.patchwork.render.RenderResourceIO;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.SimplePrint;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;

public class SpriteSheetAnimationPanel
extends FooterButtonPanel {
    private ScrollableImagePanel traceSheetPanel;
    private ScrollableImagePanel fillSheetPanel;
    private ScrollableImagePanel scanSheetPanel;
    private ScanAdjustmentPanel adjustmentPanel;
    private JFileChooser fileChooser;
    private SpriteSheet traceSequence;
    private SpriteSheet fillSequence;
    private SpriteSheet scanSequence;
    private File workingDir;
    private File scanDir;
    private File renderDir;
    private static final String SCAN_SUBDIR = "scans";
    private static final String RENDER_SUBDIR = "render";
    private static final int SCAN_PAGE_FRAME_DIGITS = 3;
    private static final int TRACE_CELL_PADDING = 3;
    private static final String TRACE_SUFFIX = "TR";
    private static final String FILL_SUFFIX = "FL";
    private static final String SHADOW_SUFFIX = "SH";
    private static final String SCAN_SUFFIX = "SC";
    private static final Pattern SCAN_PAGE_PATTERN = Pattern.compile(".*-[0-9]{3}-[0-9]{3}.png");
    private static final FileFilter SCAN_PAGE_FILE_FILTER = new FileFilter(){

        @Override
        public String getDescription() {
            return "Scan Pages";
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return SCAN_PAGE_PATTERN.matcher(f.getName()).matches();
        }
    };

    public void setTarget(File rootDir) {
        try {
            this.workingDir = rootDir;
            this.scanDir = new File(this.workingDir, SCAN_SUBDIR);
            this.renderDir = new File(this.workingDir, RENDER_SUBDIR);
            String name = this.workingDir.getName();
            this.traceSequence = new SpriteSheet(name + TRACE_SUFFIX, this.renderDir, Card.CARD_SIZE, 3);
            this.fillSequence = new SpriteSheet(name + FILL_SUFFIX, this.renderDir, Card.CARD_SIZE, 0);
            this.scanSequence = new SpriteSheet(name + SCAN_SUFFIX, this.scanDir, Card.CARD_SIZE, 0);
            this.traceSheetPanel.setImage(this.traceSequence.getSheetImage());
            this.fillSheetPanel.setImage(this.fillSequence.getSheetImage());
            this.scanSheetPanel.setImage(this.scanSequence.getSheetImage());
            this.adjustmentPanel.set(this.fillSequence, this.scanSequence);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try {
            String name = this.workingDir.getName();
            SpriteSheet shadowSequence = new SpriteSheet(name + SHADOW_SUFFIX, this.renderDir, Card.CARD_SIZE, 0);
            shadowSequence.fade(0.5f);
            List<SpriteSheet> toComposite = Arrays.asList(shadowSequence, this.fillSequence, this.adjustmentPanel.getScanSequence());
            SpriteSheet finalSequence = SpriteSheet.composite(this.workingDir.getName(), toComposite, Card.CARD_DIMENSION, 0);
            finalSequence.writeFrameImages(this.workingDir, "png", Card.CARD_DIMENSION, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected Component createMainPanel() {
        this.fileChooser = new JFileChooser();
        this.fileChooser.setCurrentDirectory(RenderResourceIO.getInstance().getAnimInputDir());
        this.traceSheetPanel = new ScrollableImagePanel();
        this.fillSheetPanel = new ScrollableImagePanel();
        this.scanSheetPanel = new ScrollableImagePanel();
        this.adjustmentPanel = new ScanAdjustmentPanel();
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Trace", this.traceSheetPanel);
        tabbedPane.addTab("Fill", this.fillSheetPanel);
        tabbedPane.addTab("Scan", this.scanSheetPanel);
        tabbedPane.addTab("Final", this.adjustmentPanel);
        return tabbedPane;
    }

    @Override
    protected Iterable<?> getButtons() {
        return EnumSet.of(MyButton.Print, MyButton.SplitScanSheets, MyButton.Save);
    }

    @Override
    protected void onButtonPress(Object key) {
        switch ((MyButton)((Object)key)) {
            case SplitScanSheets: {
                this.doSplitScanSheets();
                break;
            }
            case Print: {
                this.doPrintTraceSheets();
                break;
            }
            case Save: {
                this.save();
            }
        }
    }

    @Override
    protected void updateControlEnabling() {
        this.setButtonEnabled((Object)MyButton.Print, this.traceSequence != null);
        this.setButtonEnabled((Object)MyButton.SplitScanSheets, this.traceSequence != null);
        this.setButtonEnabled((Object)MyButton.Save, this.traceSequence != null);
    }

    private void doSplitScanSheets() {
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setFileFilter(SCAN_PAGE_FILE_FILTER);
        this.fileChooser.setMultiSelectionEnabled(true);
        this.fileChooser.setCurrentDirectory(this.scanDir);
        int result = this.fileChooser.showOpenDialog(this);
        if (result == 0) {
            for (File file : this.fileChooser.getSelectedFiles()) {
                try {
                    BufferedImage pageImage = ImageIO.read(file);
                    BufferedImage traceImage = this.traceSequence.getSheetImage();
                    String[] nameParts = FileUtils.getFilenameWithoutExtension(file.getName()).split("-");
                    assert (nameParts.length == 3);
                    String name = nameParts[0];
                    int startFrame = Integer.valueOf(nameParts[1]);
                    int endFrame = Integer.valueOf(nameParts[2]);
                    int frameCount = endFrame - startFrame + 1;
                    List<Rectangle> traceBounds = this.traceSequence.getFrameBounds();
                    ArrayList<Rectangle> scanBounds = new ArrayList<Rectangle>();
                    int traceCellPadding = this.traceSequence.getCellPadding();
                    for (int i = startFrame; i <= endFrame; ++i) {
                        Rectangle bounds = traceBounds.get(i);
                        scanBounds.add(new Rectangle(bounds.x - traceCellPadding, bounds.y - traceCellPadding, bounds.width + 2 * traceCellPadding, bounds.height + 2 * traceCellPadding));
                    }
                    List<Rectangle> frameBounds = CollectionUtils.subList(this.traceSequence.getFrameBounds(), startFrame, endFrame);
                    int gridColumns = this.traceSequence.getGridColumns();
                    int gridRows = (int)Math.ceil((float)frameCount / (float)gridColumns);
                    pageImage = ImageUtils.scale(pageImage, traceImage.getWidth(), gridRows * this.traceSequence.getCellSize().height);
                    SpriteSheet scanSheet = new SpriteSheet(name, pageImage, frameBounds, gridRows, gridColumns, 0, null);
                    Dimension imageSize = Card.CARD_DIMENSION;
                    scanSheet.writeFrameImages(file.getParentFile(), "png", imageSize, startFrame);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void doPrintTraceSheets() {
        if (this.traceSequence != null) {
            SimplePrint.getInstance().printWithDialog(this.traceSequence);
        }
    }

    private static enum MyButton {
        Print{

            public String toString() {
                return "Print Trace Sheets";
            }
        }
        ,
        SplitScanSheets{

            public String toString() {
                return "Split Scan Sheets";
            }
        }
        ,
        Save;

    }
}

