/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.animimport;

import com.sodiumarc.patchwork.animation.SpriteSheet;
import com.sodiumarc.patchwork.app.common.ScrollableImagePanel;
import com.sodiumarc.patchwork.generate.Card;
import com.sodiumarc.patchwork.util.ColorComponent;
import com.sodiumarc.patchwork.util.ColorUtils;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ScanAdjustmentPanel
extends ScrollableImagePanel {
    private SpriteSheet fillSequence;
    private SpriteSheet scanSequence;
    private JButton darkerButton;
    private JButton lighterButton;
    private JLabel cumulativeAlphaLabel;
    private JButton maskButton;
    private float cumulativeAlphaScale = 1.0f;

    public ScanAdjustmentPanel() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ScanAdjustmentPanel.this.onKeyTyped(e.getKeyCode());
            }
        });
        this.getImagePanel().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ScanAdjustmentPanel.this.onClick(e.getPoint());
            }
        });
    }

    public void set(SpriteSheet fillSequence, SpriteSheet scanSequence) {
        this.fillSequence = fillSequence;
        this.scanSequence = scanSequence;
        this.setCumulativeAlphaScale(1.0f);
        this.update();
    }

    public SpriteSheet getScanSequence() {
        return this.scanSequence;
    }

    @Override
    protected Component getBottomComponent() {
        JPanel panel = new JPanel(new FlowLayout());
        this.darkerButton = new JButton("Darker");
        this.darkerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScanAdjustmentPanel.this.scaleAlpha(1.1f);
            }
        });
        this.lighterButton = new JButton("Lighter");
        this.lighterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScanAdjustmentPanel.this.scaleAlpha(0.9f);
            }
        });
        this.cumulativeAlphaLabel = new JLabel(Float.toString(this.cumulativeAlphaScale));
        this.maskButton = new JButton("Mask");
        this.maskButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScanAdjustmentPanel.this.scanSequence = SpriteSheet.mask(ScanAdjustmentPanel.this.scanSequence, ScanAdjustmentPanel.this.fillSequence, Card.CARD_DIMENSION, 2);
                ScanAdjustmentPanel.this.update();
            }
        });
        panel.add(this.darkerButton);
        panel.add(this.cumulativeAlphaLabel);
        panel.add(this.lighterButton);
        panel.add(this.maskButton);
        return panel;
    }

    private void update() {
        this.updateControlEnabling();
        if (this.fillSequence == null || this.scanSequence == null) {
            this.setImage(null);
            return;
        }
        List<SpriteSheet> toComposite = Arrays.asList(this.fillSequence, this.scanSequence);
        SpriteSheet composite = SpriteSheet.composite("composite", toComposite, Card.CARD_DIMENSION, 0);
        this.setImage(composite.getSheetImage());
    }

    private void updateControlEnabling() {
        boolean enabled = this.fillSequence != null && this.scanSequence != null;
        this.darkerButton.setEnabled(enabled);
        this.lighterButton.setEnabled(enabled);
        this.maskButton.setEnabled(enabled);
    }

    protected void onClick(Point point) {
        if (this.fillSequence == null || this.scanSequence == null) {
            return;
        }
        this.requestFocusInWindow();
    }

    private void onKeyTyped(int keyCode) {
        int dx = 0;
        int dy = 0;
        switch (keyCode) {
            case 87: {
                dy = -1;
                break;
            }
            case 83: {
                dy = 1;
                break;
            }
            case 65: {
                dx = -1;
                break;
            }
            case 68: {
                dx = 1;
            }
        }
        this.offsetScanImages(dx, dy);
        this.update();
    }

    private void offsetScanImages(int dx, int dy) {
        ArrayList<Rectangle> newBounds = new ArrayList<Rectangle>();
        for (Rectangle oldBounds : this.scanSequence.getFrameBounds()) {
            newBounds.add(new Rectangle(oldBounds.x + dx, oldBounds.y + dy, oldBounds.width, oldBounds.height));
        }
        this.scanSequence.setFrameBounds(newBounds);
    }

    private void scaleAlpha(float alphaScale) {
        this.scaleAlpha(this.scanSequence.getSheetImage(), alphaScale);
        this.setCumulativeAlphaScale(this.cumulativeAlphaScale * alphaScale);
        this.update();
    }

    private void scaleAlpha(BufferedImage image, float scale) {
        if (scale == 1.0f) {
            return;
        }
        int n = image.getWidth();
        for (int x = 0; x < n; ++x) {
            int m = image.getHeight();
            for (int y = 0; y < m; ++y) {
                int color = image.getRGB(x, y);
                int alpha = ColorUtils.getComponent(color, ColorComponent.ALPHA);
                alpha = Math.min((int)(scale * (float)alpha), 255);
                color = ColorUtils.setComponent(color, ColorComponent.ALPHA, alpha);
                image.setRGB(x, y, color);
            }
        }
    }

    private void setCumulativeAlphaScale(float cumulativeAlphaScale) {
        this.cumulativeAlphaScale = cumulativeAlphaScale;
        this.cumulativeAlphaLabel.setText(Float.toString(cumulativeAlphaScale));
    }
}

