/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.app.animimport;

import com.sodiumarc.patchwork.app.animimport.SpriteSheetAnimationPanel;
import com.sodiumarc.patchwork.app.common.SimpleApp;
import com.sodiumarc.patchwork.render.RenderResourceIO;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

public class AnimImportApp
extends SimpleApp {
    public static String TITLE = "Animation Import Application";
    private SpriteSheetAnimationPanel mainPanel;
    private JFileChooser fileChooser;

    public static void main(String[] args) {
        AnimImportApp.launchApp(args, new AnimImportApp());
    }

    public AnimImportApp() throws HeadlessException {
        super(TITLE, 700, 600);
        this.setSaveAlwaysEnabled(true);
    }

    @Override
    protected Component createMainPanel(SimpleApp app) {
        this.fileChooser = new JFileChooser();
        this.fileChooser.setCurrentDirectory(RenderResourceIO.getInstance().getAnimInputDir());
        AbstractAction openAction = new AbstractAction("Open..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnimImportApp.this.doOpen();
            }
        };
        this.addAppMenuItem(openAction, "control O");
        this.mainPanel = new SpriteSheetAnimationPanel();
        return this.mainPanel;
    }

    @Override
    protected void onSave() {
        this.mainPanel.save();
    }

    private void doOpen() {
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setFileFilter(null);
        this.fileChooser.setMultiSelectionEnabled(false);
        int result = this.fileChooser.showOpenDialog(this);
        if (result == 0) {
            this.mainPanel.setTarget(this.fileChooser.getSelectedFile());
        }
    }
}

