/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.FileUtils;
import com.sodiumarc.patchwork.animation.ImageAnimation;
import com.sodiumarc.patchwork.animation.SpriteSheet;
import com.sodiumarc.patchwork.generate.Card;
import com.sodiumarc.patchwork.render.RenderResourceIO;
import com.sodiumarc.patchwork.util.MathUtils;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class SpriteSheetAnimation
extends ImageAnimation {
    private final String name;
    private final File animationDir;
    private final Dimension outputImageSize;
    private final List<Integer> frameSourceIndices;
    private SpriteSheet sequence;
    private static final int FRAME_PATTERN_DIGITS = 3;
    private static final int SOURCE_FPS = 12;
    private int currentFrameIndex = 0;
    private List<BufferedImage> frameImages;

    public static SpriteSheetAnimation get(String animationName, Dimension outputImageSize) throws IOException {
        return SpriteSheetAnimation.get(RenderResourceIO.getInstance().getAnimInputDir(), animationName, outputImageSize);
    }

    public static SpriteSheetAnimation get(File animParentDirectory, String animationName, Dimension outputImageSize) throws IOException {
        File inputDirectory = new File(animParentDirectory, animationName);
        return new SpriteSheetAnimation(inputDirectory, outputImageSize);
    }

    public String getName() {
        return this.name;
    }

    public File getAnimationDir() {
        return this.animationDir;
    }

    public BufferedImage getSheetImage() {
        return this.sequence.getSheetImage();
    }

    public List<Point> getFrameOffsets() {
        return this.sequence.getFrameOffsets();
    }

    public int getFrameCount() {
        return this.frameSourceIndices.size();
    }

    public int getColumnCount() {
        return this.sequence.getGridColumns();
    }

    public int getRowCount() {
        return this.sequence.getGridRows();
    }

    public void setFramesPerSecond(int fps) {
        int firstSourceIndex = this.frameSourceIndices.get(0);
        int lastSourceIndex = this.frameSourceIndices.get(this.frameSourceIndices.size() - 1);
        this.setDurationInMillis((int)((float)(lastSourceIndex - firstSourceIndex) / (float)fps * 1000.0f));
    }

    @Override
    public BufferedImage getCurrentImage() {
        if (this.frameImages == null) {
            this.frameImages = this.sequence.getFrameImages(this.outputImageSize);
        }
        return this.frameImages.get(this.currentFrameIndex);
    }

    @Override
    protected void elapsedFractionChanged(float elapsedFraction) {
        int lastFrameIndex = this.sequence.getFrameCount() - 1;
        int frameIndex = (int)Math.round(MathUtils.interpolate(elapsedFraction, 0.0, lastFrameIndex));
        this.currentFrameIndex = MathUtils.clamp(frameIndex, 0, lastFrameIndex);
    }

    private SpriteSheetAnimation(File animationDir, Dimension outputImageSize) throws IOException {
        this.animationDir = animationDir;
        this.outputImageSize = outputImageSize;
        this.name = animationDir.getName();
        Pattern framePattern = Pattern.compile(this.name + "[0-9]{" + 3 + "}");
        File[] files = animationDir.listFiles();
        this.frameSourceIndices = this.getFrameSourceIndices(files, framePattern);
        this.sequence = new SpriteSheet(this.name, animationDir, Card.CARD_SIZE, 0);
        this.setFramesPerSecond(12);
    }

    private List<Integer> getFrameSourceIndices(File[] animFiles, Pattern framePattern) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (File animFile : animFiles) {
            String fileBase = FileUtils.getFilenameWithoutExtension(animFile.getName());
            if (!framePattern.matcher(fileBase).matches()) continue;
            int frameSourceIndex = Integer.parseInt(fileBase.substring(fileBase.length() - 3));
            result.add(frameSourceIndex);
        }
        return result;
    }
}

