/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.FileUtils;
import com.sodiumarc.patchwork.util.Collection.MultiMap;
import com.sodiumarc.patchwork.util.ColorComponent;
import com.sodiumarc.patchwork.util.ColorUtils;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.StringUtils;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import com.sodiumarc.patchwork.util.xml.SimpleTranscoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SpriteSheet
implements Printable,
Pageable {
    private BufferedImage sheetImage;
    private final String name;
    private final int cellPadding;
    private final Dimension cellSize;
    private final int gridColumns;
    private final int gridRows;
    private Dimension outputFrameSize;
    private float printAlpha = 0.4f;
    private final List<Rectangle> frameNonEmptyBounds;
    private static final PageFormat PAGE_FORMAT = new PageFormat();
    private static final int PRINT_MARGIN = 20;
    private static final int FRAME_PATTERN_DIGITS = 3;
    private static final int DEFAULT_MAX_SHEET_WIDTH = 800;
    private static final String SHEET_IMAGE_SUFFIX = ".SHEET";
    private static final String PROPERTIES_SUFFIX = ".PROPS";

    public static String getSheetImageFilename(String name) {
        return name + SHEET_IMAGE_SUFFIX + ".png";
    }

    public static String getPropertiesFilename(String name) {
        return name + PROPERTIES_SUFFIX + ".xml";
    }

    public static SpriteSheet load(File directory, String name) {
        File imageFile = new File(directory, SpriteSheet.getSheetImageFilename(name));
        File propsFile = new File(directory, SpriteSheet.getPropertiesFilename(name));
        return SpriteSheet.load(imageFile, propsFile);
    }

    public static SpriteSheet load(File imageFile, File propsFile) {
        BufferedImage sheetImage = null;
        Document document = null;
        try {
            sheetImage = ImageIO.read(imageFile);
            document = XMLUtils.getXMLDocument(propsFile, false);
        }
        catch (IOException e) {
            return null;
        }
        catch (ParserConfigurationException e) {
            return null;
        }
        catch (SAXException e) {
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        if (sheetImage == null || document == null) {
            return null;
        }
        return (SpriteSheet)new Transcoder(sheetImage).decode(document.getDocumentElement());
    }

    public static SpriteSheet load(InputStream imageFile, InputStream propsFile) {
        BufferedImage sheetImage = null;
        Document document = null;
        try {
            sheetImage = ImageIO.read(imageFile);
            document = XMLUtils.getXMLDocument(propsFile, false);
        }
        catch (IOException e) {
            return null;
        }
        catch (ParserConfigurationException e) {
            return null;
        }
        catch (SAXException e) {
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        if (sheetImage == null || document == null) {
            return null;
        }
        return (SpriteSheet)new Transcoder(sheetImage).decode(document.getDocumentElement());
    }

    public static SpriteSheet composite(String name, List<SpriteSheet> toComposite, Dimension imageSize, int cellPadding) {
        int maxFrameCount = -1;
        for (SpriteSheet sequence : toComposite) {
            maxFrameCount = Math.max(maxFrameCount, sequence.getFrameCount());
        }
        ArrayList<BufferedImage> compositeImages = new ArrayList<BufferedImage>();
        for (int i = 0; i <= maxFrameCount; ++i) {
            BufferedImage compositeImage = new BufferedImage(imageSize.width, imageSize.height, 2);
            Graphics g = compositeImage.getGraphics();
            for (SpriteSheet sequence : toComposite) {
                if (i >= sequence.getFrameCount()) continue;
                BufferedImage layerImage = sequence.getFrameImage(i, imageSize);
                g.drawImage(layerImage, 0, 0, null);
            }
            g.dispose();
            compositeImages.add(compositeImage);
        }
        return new SpriteSheet(name, compositeImages, cellPadding);
    }

    public static SpriteSheet mask(SpriteSheet toMask, SpriteSheet mask, Dimension imageSize, int fudgeRadius) {
        ArrayList<BufferedImage> maskedImages = new ArrayList<BufferedImage>();
        for (int i = 0; i < toMask.getFrameCount(); ++i) {
            if (i >= mask.getFrameCount()) continue;
            BufferedImage maskImage = SpriteSheet.createMask(mask.getFrameImage(i, imageSize), fudgeRadius);
            BufferedImage maskedImage = SpriteSheet.applyMask(toMask.getFrameImage(i, imageSize), maskImage);
            maskedImages.add(maskedImage);
        }
        return new SpriteSheet(toMask.getName(), maskedImages, toMask.getCellPadding());
    }

    public static List<Integer> getFrameSourceIndices(String name, File directory) {
        File[] files;
        ArrayList<Integer> result = new ArrayList<Integer>();
        Pattern framePattern = Pattern.compile(name + "[0-9]{" + 3 + "}");
        for (File animFile : files = directory.listFiles()) {
            String fileBase = FileUtils.getFilenameWithoutExtension(animFile.getName());
            if (!framePattern.matcher(fileBase).matches()) continue;
            int frameSourceIndex = Integer.parseInt(fileBase.substring(fileBase.length() - 3));
            result.add(frameSourceIndex);
        }
        return result;
    }

    public SpriteSheet(String name, BufferedImage sheetImage, List<Rectangle> frameBounds, int gridRows, int gridColumns, int cellPadding, Dimension outputFrameSize) {
        this.name = name;
        this.sheetImage = sheetImage;
        this.frameNonEmptyBounds = frameBounds;
        this.gridRows = gridRows;
        this.gridColumns = gridColumns;
        this.cellPadding = cellPadding;
        this.outputFrameSize = outputFrameSize;
        this.cellSize = gridRows == 0 ? new Dimension(0, 0) : new Dimension(sheetImage.getWidth() / gridColumns, sheetImage.getHeight() / gridRows);
    }

    public SpriteSheet(String name, File directory, int frameImageSize, int cellPadding) throws IOException {
        this(name, SpriteSheet.loadFrameImages(name, directory, frameImageSize), cellPadding);
    }

    public SpriteSheet(String name, List<BufferedImage> frameImages, int cellPadding) {
        this(name, frameImages, SpriteSheet.computeFrameBounds(frameImages), cellPadding, 800, null);
    }

    public SpriteSheet(String name, List<BufferedImage> frameImages, int cellPadding, int maxSheetWidth, Dimension outputFrameSize) {
        this(name, frameImages, SpriteSheet.computeFrameBounds(frameImages), cellPadding, maxSheetWidth, outputFrameSize);
    }

    public SpriteSheet(String name, List<BufferedImage> frameImages, List<Rectangle> frameBounds, int cellPadding, int maxSheetWidth, Dimension outputFrameSize) {
        assert (frameImages.size() == frameBounds.size());
        Dimension maxFrameSize = this.getMaxSize(frameBounds);
        this.name = name;
        this.cellPadding = cellPadding;
        this.frameNonEmptyBounds = frameBounds;
        this.outputFrameSize = outputFrameSize;
        this.cellSize = new Dimension(maxFrameSize.width + 2 * cellPadding, maxFrameSize.height + 2 * cellPadding);
        this.gridColumns = maxSheetWidth / this.cellSize.width;
        this.gridRows = (int)Math.ceil((float)frameImages.size() / (float)this.gridColumns);
        int sheetWidth = this.gridColumns * this.cellSize.width;
        int sheetHeight = this.gridRows * this.cellSize.height;
        this.sheetImage = new BufferedImage(Math.max(sheetWidth, 1), Math.max(sheetHeight, 1), 2);
        Graphics2D g = (Graphics2D)this.sheetImage.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        int frameIndex = 0;
        block0: for (int y = 0; y < this.gridRows; ++y) {
            for (int x = 0; x < this.gridColumns; ++x) {
                BufferedImage frameImage = frameImages.get(frameIndex);
                Rectangle thisFrameBounds = frameBounds.get(frameIndex);
                if (thisFrameBounds.width > 0 && thisFrameBounds.height > 0) {
                    BufferedImage cellImage = ImageUtils.safeSubimage(frameImage, thisFrameBounds.x, thisFrameBounds.y, thisFrameBounds.width, thisFrameBounds.height);
                    g.drawImage((Image)cellImage, x * this.cellSize.width + cellPadding, y * this.cellSize.height + cellPadding, null);
                }
                if (++frameIndex == frameImages.size()) continue block0;
            }
        }
        g.dispose();
    }

    public int getCellPadding() {
        return this.cellPadding;
    }

    public BufferedImage getSheetImage() {
        return this.sheetImage;
    }

    public String getName() {
        return this.name;
    }

    public int getGridColumns() {
        return this.gridColumns;
    }

    public int getGridRows() {
        return this.gridRows;
    }

    public Dimension getCellSize() {
        return this.cellSize;
    }

    public int getFrameCount() {
        return this.frameNonEmptyBounds.size();
    }

    public List<Point> getFrameOffsets() {
        ArrayList<Point> result = new ArrayList<Point>();
        for (Rectangle bounds : this.frameNonEmptyBounds) {
            result.add(new Point(bounds.x, bounds.y));
        }
        return result;
    }

    public List<Rectangle> getFrameBounds() {
        return this.frameNonEmptyBounds;
    }

    public void setFrameBounds(List<Rectangle> bounds) {
        assert (bounds.size() == this.frameNonEmptyBounds.size());
        this.frameNonEmptyBounds.clear();
        this.frameNonEmptyBounds.addAll(bounds);
    }

    public Rectangle getFrameBounds(int index) {
        return this.frameNonEmptyBounds.get(index);
    }

    public List<BufferedImage> getFrameImages(Dimension imageSize) {
        return this.getFrameImages(imageSize, 0);
    }

    public List<BufferedImage> getFrameImages(Dimension imageSize, int marginAdjustment) {
        ArrayList<BufferedImage> result = new ArrayList<BufferedImage>();
        for (int i = 0; i < this.frameNonEmptyBounds.size(); ++i) {
            result.add(this.getFrameImage(i, imageSize, marginAdjustment));
        }
        return result;
    }

    public BufferedImage getFrameImage(int index, Dimension imageSize) {
        return this.getFrameImage(index, imageSize, 0);
    }

    public Dimension getOutputFrameSize() {
        return this.outputFrameSize;
    }

    public void setOutputFrameSize(Dimension outputFrameSize) {
        this.outputFrameSize = outputFrameSize;
    }

    public BufferedImage getFrameImage(int index, Dimension imageSize, int marginAdjustment) {
        if (index >= this.getFrameCount()) {
            return null;
        }
        marginAdjustment = MathUtils.clamp(marginAdjustment, 0, this.cellPadding);
        Rectangle bounds = this.frameNonEmptyBounds.get(index);
        if (marginAdjustment > 0) {
            bounds = new Rectangle(bounds);
            bounds.grow(marginAdjustment, marginAdjustment);
        }
        BufferedImage frameImage = SpriteSheet.extractFrameImage(this.sheetImage, index, this.gridRows, this.gridColumns, this.cellPadding - marginAdjustment);
        float outputScaleX = 1.0f;
        float outputScaleY = 1.0f;
        if (this.outputFrameSize != null && !this.outputFrameSize.equals(imageSize)) {
            outputScaleX = (float)(imageSize.getWidth() / this.outputFrameSize.getWidth());
            outputScaleY = (float)(imageSize.getHeight() / this.outputFrameSize.getHeight());
            frameImage = ImageUtils.scale(frameImage, outputScaleX, outputScaleY);
        }
        if (imageSize != null && (frameImage.getWidth() != imageSize.width || frameImage.getHeight() != imageSize.height)) {
            BufferedImage paddedImage = new BufferedImage(imageSize.width, imageSize.height, 2);
            Graphics2D g = (Graphics2D)paddedImage.getGraphics();
            g.drawImage((Image)frameImage, (int)((float)bounds.x * outputScaleX), (int)((float)bounds.y * outputScaleY), null);
            g.dispose();
            return paddedImage;
        }
        return frameImage;
    }

    public void writeFrameImages(File directory, String imageFormat, Dimension imageSize, int startingFrameNumber) throws IOException {
        String filenameFormat = this.name + "%1$03d." + imageFormat;
        int frameNumber = startingFrameNumber;
        for (BufferedImage image : this.getFrameImages(imageSize)) {
            File outputFile = new File(directory, String.format(filenameFormat, frameNumber));
            FileImageOutputStream fileOut = new FileImageOutputStream(outputFile);
            ImageIO.write((RenderedImage)image, imageFormat, fileOut);
            fileOut.close();
            ++frameNumber;
        }
    }

    public void fade(float value) {
        this.sheetImage = this.fade(this.sheetImage, value);
    }

    public float getPrintAlpha() {
        return this.printAlpha;
    }

    public void setPrintAlpha(float printAlpha) {
        this.printAlpha = printAlpha;
    }

    public void save(File directory) throws IOException {
        this.save(directory, this.name);
    }

    public void save(File directory, String name) throws IOException {
        Document doc;
        assert (directory != null) : "directory is null";
        File imageFile = new File(directory, SpriteSheet.getSheetImageFilename(name));
        File propsFile = new File(directory, SpriteSheet.getPropertiesFilename(name));
        ImageUtils.saveImage(this.sheetImage, imageFile);
        try {
            doc = XMLUtils.newXMLDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return;
        }
        Comment comment = doc.createComment("Properties for " + name);
        doc.appendChild(comment);
        doc.appendChild(new Transcoder(null).encode(doc, this));
        try {
            XMLUtils.writeXMLDocument(doc, propsFile);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getNumberOfPages() {
        Dimension cellSize = this.getCellSize();
        Dimension pageDimension = new Dimension((int)PAGE_FORMAT.getImageableWidth(), (int)PAGE_FORMAT.getImageableHeight());
        Rectangle sheetDestRectangle = new Rectangle(20, 20, pageDimension.width - 40, pageDimension.height - 40);
        int rowsPerPage = sheetDestRectangle.height / cellSize.height;
        return (int)Math.ceil((float)this.getGridRows() / (float)rowsPerPage);
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return PAGE_FORMAT;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= this.getNumberOfPages()) {
            return 1;
        }
        Dimension cellSize = this.getCellSize();
        int gridColumns = this.getGridColumns();
        BufferedImage sheetImage = this.getSheetImage();
        Dimension pageDimension = new Dimension((int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        Rectangle sheetDestRectangle = new Rectangle(20, 20, pageDimension.width - 40, pageDimension.height - 40);
        int rowsPerPage = sheetDestRectangle.height / cellSize.height;
        int pageStartRow = pageIndex * rowsPerPage;
        int pageStartFrame = pageStartRow * gridColumns;
        int pageEndFrame = (pageStartRow + rowsPerPage) * gridColumns - 1;
        pageEndFrame = Math.min(pageEndFrame, this.getFrameCount() - 1);
        int thisYStart = pageStartRow * cellSize.height;
        int nextYStart = (pageStartRow + rowsPerPage) * cellSize.height;
        int sourceHeight = Math.min(sheetImage.getHeight(), nextYStart) - thisYStart;
        BufferedImage subsheetImage = sheetImage.getSubimage(0, thisYStart, sheetImage.getWidth(), sourceHeight);
        subsheetImage = this.fade(subsheetImage, this.printAlpha);
        Graphics2D g2d = (Graphics2D)graphics;
        AffineTransform restoreTransform = g2d.getTransform();
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics.setColor(Color.BLUE);
        graphics.drawString(this.getName() + "(" + pageStartFrame + " - " + pageEndFrame + ") fade = " + this.printAlpha, sheetDestRectangle.x - 1, sheetDestRectangle.y - 5);
        graphics.drawRect(sheetDestRectangle.x - 1, sheetDestRectangle.y - 1, sheetDestRectangle.width + 2, sheetDestRectangle.height + 2);
        float widthScale = (float)sheetDestRectangle.width / (float)(gridColumns * cellSize.width);
        float heightScale = (float)sheetDestRectangle.height / (float)(rowsPerPage * cellSize.height);
        float subsheetScale = Math.min(widthScale, heightScale);
        BufferedImage scaledSubsheetImage = ImageUtils.scale(subsheetImage, subsheetScale, subsheetScale);
        graphics.drawImage(scaledSubsheetImage, sheetDestRectangle.x, sheetDestRectangle.y, null);
        g2d.setTransform(restoreTransform);
        return 0;
    }

    private Dimension getMaxSize(List<Rectangle> frameBounds) {
        int maxWidth = -1;
        int maxHeight = -1;
        for (Rectangle bounds : frameBounds) {
            maxWidth = Math.max(maxWidth, bounds.width);
            maxHeight = Math.max(maxHeight, bounds.height);
        }
        return new Dimension(maxWidth, maxHeight);
    }

    private BufferedImage fade(BufferedImage image, float mult) {
        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        int n = image.getWidth();
        for (int x = 0; x < n; ++x) {
            int m = image.getHeight();
            for (int y = 0; y < m; ++y) {
                int color = image.getRGB(x, y);
                int alpha = ColorUtils.getComponent(color, ColorComponent.ALPHA);
                int tone = ColorUtils.getIntensity(color);
                color = ColorUtils.toIntARGB((int)(mult * (float)alpha), tone, tone, tone);
                result.setRGB(x, y, color);
            }
        }
        return result;
    }

    private static List<Rectangle> computeFrameBounds(List<BufferedImage> frameImages) {
        ArrayList<Rectangle> result = new ArrayList<Rectangle>();
        for (BufferedImage frameImage : frameImages) {
            result.add(ImageUtils.getVisibleRegion(frameImage));
        }
        return result;
    }

    private static BufferedImage extractFrameImage(BufferedImage sheetImage, int indexInSheet, int gridRows, int gridColumns, int cellPadding) {
        Dimension cellSize = new Dimension(sheetImage.getWidth() / gridColumns, sheetImage.getHeight() / gridRows);
        int row = indexInSheet / gridColumns;
        int column = indexInSheet % gridColumns;
        return sheetImage.getSubimage(column * cellSize.width + cellPadding, row * cellSize.height + cellPadding, cellSize.width - 2 * cellPadding, cellSize.height - 2 * cellPadding);
    }

    private static List<BufferedImage> loadFrameImages(String name, File directory, int frameImageSize) throws IOException {
        ArrayList<BufferedImage> result = new ArrayList<BufferedImage>();
        Pattern framePattern = Pattern.compile(name + "[0-9]{" + 3 + "}");
        Pattern boundsPattern = Pattern.compile(name + "BOUNDS");
        File[] files = directory.listFiles();
        if (files == null) {
            return result;
        }
        Rectangle viewportBounds = SpriteSheet.getViewportBounds(files, boundsPattern);
        for (File file : files) {
            String fileBase = FileUtils.getFilenameWithoutExtension(file.getName());
            if (!framePattern.matcher(fileBase).matches()) continue;
            BufferedImage frameImage = ImageIO.read(file);
            if (viewportBounds != null) {
                frameImage = ImageUtils.scale(frameImage.getSubimage(viewportBounds.x, viewportBounds.y, viewportBounds.width, viewportBounds.height), frameImageSize, frameImageSize);
            }
            result.add(frameImage);
        }
        return result;
    }

    private static Rectangle getViewportBounds(File[] animFiles, Pattern boundsPattern) throws IOException {
        Rectangle result = null;
        for (File animFile : animFiles) {
            String fileBase = FileUtils.getFilenameWithoutExtension(animFile.getName());
            if (!boundsPattern.matcher(fileBase).matches()) continue;
            BufferedImage boundsImage = ImageIO.read(animFile);
            result = ImageUtils.getVisibleRegion(boundsImage);
        }
        return result;
    }

    private static BufferedImage createMask(BufferedImage source, int fudgeRadius) {
        BufferedImage mask = new BufferedImage(source.getWidth(), source.getHeight(), 2);
        int w = source.getWidth();
        for (int x = 0; x < w; ++x) {
            int h = source.getHeight();
            for (int y = 0; y < h; ++y) {
                int sourceColor = source.getRGB(x, y);
                int alpha = ColorUtils.getComponent(sourceColor, ColorComponent.ALPHA);
                if (alpha <= 0) continue;
                for (int dx = -fudgeRadius; dx <= fudgeRadius; ++dx) {
                    for (int dy = -fudgeRadius; dy <= fudgeRadius; ++dy) {
                        mask.setRGB(MathUtils.clamp(x + dx, 0, w), MathUtils.clamp(y + dy, 0, h), -1);
                    }
                }
            }
        }
        return mask;
    }

    private static BufferedImage applyMask(BufferedImage toMask, BufferedImage mask) {
        BufferedImage result = new BufferedImage(toMask.getWidth(), toMask.getHeight(), 2);
        int w = toMask.getWidth();
        for (int x = 0; x < w; ++x) {
            int h = toMask.getHeight();
            for (int y = 0; y < h; ++y) {
                int maskColor = mask.getRGB(x, y);
                int alpha = ColorUtils.getComponent(maskColor, ColorComponent.ALPHA);
                if (alpha == 0) continue;
                result.setRGB(x, y, toMask.getRGB(x, y));
            }
        }
        return result;
    }

    private static class Transcoder
    extends SimpleTranscoder<SpriteSheet> {
        private static final String ELEMENT_NAME = "SpriteSheet";
        private static final String ATTR_NAME = "name";
        private static final String ATTR_GRID_ROWS = "sheetRows";
        private static final String ATTR_GRID_COLUMNS = "sheetColumns";
        private static final String ATTR_CELL_PADDING = "cellPadding";
        private static final String ATTR_FRAME_BOUNDS = "frameBounds";
        private static final String ATTR_OUTPUT_SIZE = "outputSize";
        private final BufferedImage sheetImage;

        public Transcoder(BufferedImage sheetImage) {
            super(ELEMENT_NAME, SpriteSheet.class);
            this.sheetImage = sheetImage;
        }

        @Override
        protected SpriteSheet decode(Map<String, String> attributes, MultiMap<String, Object> decodedChildren) {
            String name = attributes.get(ATTR_NAME);
            int cellPadding = 1;
            if (attributes.containsKey(ATTR_CELL_PADDING)) {
                cellPadding = Integer.valueOf(attributes.get(ATTR_CELL_PADDING));
            }
            int sheetRows = 1;
            if (attributes.containsKey(ATTR_GRID_ROWS)) {
                sheetRows = Integer.valueOf(attributes.get(ATTR_GRID_ROWS));
            }
            int sheetColumns = 1;
            if (attributes.containsKey(ATTR_GRID_COLUMNS)) {
                sheetColumns = Integer.valueOf(attributes.get(ATTR_GRID_COLUMNS));
            }
            Dimension frameOutputSize = null;
            if (attributes.containsKey(ATTR_OUTPUT_SIZE)) {
                frameOutputSize = StringUtils.decodeDimension(attributes.get(ATTR_OUTPUT_SIZE));
            }
            ArrayList<Rectangle> frameBounds = new ArrayList<Rectangle>();
            if (attributes.containsKey(ATTR_FRAME_BOUNDS)) {
                Collection<String> encodedBoundsList = StringUtils.split(attributes.get(ATTR_FRAME_BOUNDS), ";", true, new ArrayList<String>());
                for (String encodedBounds : encodedBoundsList) {
                    frameBounds.add(StringUtils.decodeRectangle(encodedBounds));
                }
            }
            return new SpriteSheet(name, this.sheetImage, new ArrayList<Rectangle>(frameBounds), sheetRows, sheetColumns, cellPadding, frameOutputSize);
        }

        @Override
        protected void getAttributes(SpriteSheet object, Map<String, String> destination) {
            destination.put(ATTR_NAME, object.name);
            destination.put(ATTR_CELL_PADDING, Integer.toString(object.cellPadding));
            destination.put(ATTR_GRID_ROWS, Integer.toString(object.gridRows));
            destination.put(ATTR_GRID_COLUMNS, Integer.toString(object.gridColumns));
            if (object.outputFrameSize != null) {
                destination.put(ATTR_OUTPUT_SIZE, StringUtils.encodeDimension(object.outputFrameSize));
            }
            ArrayList<String> encodedBounds = new ArrayList<String>();
            for (Rectangle bounds : object.frameNonEmptyBounds) {
                encodedBounds.add(StringUtils.encodeRectangle(bounds));
            }
            if (!encodedBounds.isEmpty()) {
                destination.put(ATTR_FRAME_BOUNDS, StringUtils.toDelimitedList(encodedBounds, ";"));
            }
        }
    }
}

