/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.FileUtils;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.image.ImageUtils;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class SpriteSequence {
    private final String name;
    private final List<BufferedImage> croppedFrameImages;
    private final List<Dimension> frameDimensions;
    private final List<Rectangle> frameNonEmptyBounds;
    private final List<Integer> frameSourceIndices;
    private static final int FRAME_PATTERN_DIGITS = 3;

    public static Rectangle4d getViewportProportional(String name, File directory) throws IOException {
        File[] files;
        Rectangle4d result = null;
        Pattern boundsPattern = Pattern.compile(name + "BOUNDS");
        for (File animFile : files = directory.listFiles()) {
            String fileBase = FileUtils.getFilenameWithoutExtension(animFile.getName());
            if (!boundsPattern.matcher(fileBase).matches()) continue;
            BufferedImage boundsImage = ImageIO.read(animFile);
            Rectangle4d sourceRect = new Rectangle4d(0.0, 0.0, boundsImage.getWidth(), boundsImage.getHeight());
            result = sourceRect.toProportional(new Rectangle4d(ImageUtils.getVisibleRegion(boundsImage)));
        }
        return result;
    }

    public SpriteSequence(String name, File directory) throws IOException {
        this(name, directory, SpriteSequence.getViewportProportional(name, directory));
    }

    public SpriteSequence(String name, File directory, Rectangle4d viewportProportional) throws IOException {
        this.name = name;
        this.croppedFrameImages = new ArrayList<BufferedImage>();
        this.frameDimensions = new ArrayList<Dimension>();
        this.frameNonEmptyBounds = new ArrayList<Rectangle>();
        this.frameSourceIndices = new ArrayList<Integer>();
        Pattern framePattern = Pattern.compile(name + "[0-9]{" + 3 + "}");
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String fileBase = FileUtils.getFilenameWithoutExtension(file.getName());
            if (!framePattern.matcher(fileBase).matches()) continue;
            BufferedImage frameImage = ImageIO.read(file);
            int frameSourceIndex = Integer.parseInt(fileBase.substring(fileBase.length() - 3));
            this.frameSourceIndices.add(frameSourceIndex);
            this.addRawFrameImage(frameImage, viewportProportional);
        }
    }

    public SpriteSequence(String name, List<BufferedImage> rawFrameImages, Rectangle4d viewportProportional) {
        this.name = name;
        this.croppedFrameImages = new ArrayList<BufferedImage>();
        this.frameDimensions = new ArrayList<Dimension>();
        this.frameNonEmptyBounds = new ArrayList<Rectangle>();
        this.frameSourceIndices = new ArrayList<Integer>();
        int index = 0;
        for (BufferedImage frameImage : rawFrameImages) {
            this.frameSourceIndices.add(index++);
            this.addRawFrameImage(frameImage, viewportProportional);
        }
    }

    public SpriteSequence(String name, List<BufferedImage> croppedFrameImages, List<Dimension> frameDimensions, List<Rectangle> frameNonEmptyBounds) {
        this.name = name;
        this.croppedFrameImages = croppedFrameImages;
        this.frameDimensions = frameDimensions;
        this.frameNonEmptyBounds = frameNonEmptyBounds;
        this.frameSourceIndices = new ArrayList<Integer>(croppedFrameImages.size());
        for (int i = 0; i < croppedFrameImages.size(); ++i) {
            this.frameSourceIndices.add(i);
        }
    }

    public String getName() {
        return this.name;
    }

    public List<BufferedImage> getFrameImages(Dimension imageSize) {
        ArrayList<BufferedImage> result = new ArrayList<BufferedImage>();
        for (int i = 0; i < this.frameNonEmptyBounds.size(); ++i) {
            result.add(this.getFrameImage(i, imageSize));
        }
        return result;
    }

    public BufferedImage getFrameImage(int index, Dimension destSize) {
        if (index >= this.croppedFrameImages.size()) {
            return null;
        }
        Rectangle bounds = this.frameNonEmptyBounds.get(index);
        BufferedImage croppedImage = this.croppedFrameImages.get(index);
        if (destSize != null) {
            BufferedImage resultImage = new BufferedImage(destSize.width, destSize.height, 2);
            if (bounds.width > 0 && bounds.height > 0) {
                Dimension sourceSize = this.frameDimensions.get(index);
                Graphics2D g = (Graphics2D)resultImage.getGraphics();
                AffineTransform scaleTransform = new AffineTransform();
                scaleTransform.setToScale(destSize.getWidth() / sourceSize.getWidth(), destSize.getHeight() / sourceSize.getHeight());
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g.setTransform(scaleTransform);
                g.drawImage((Image)croppedImage, bounds.x, bounds.y, null);
                g.dispose();
            }
            return resultImage;
        }
        return croppedImage;
    }

    public List<Integer> getFrameSourceIndices() {
        return this.frameSourceIndices;
    }

    private void addRawFrameImage(BufferedImage frameImage, Rectangle4d viewportProportional) {
        if (viewportProportional != null) {
            Rectangle4d sourceRect = new Rectangle4d(0.0, 0.0, frameImage.getWidth(), frameImage.getHeight());
            Rectangle viewportBounds = sourceRect.fromProportional(viewportProportional).asAWTRectangle();
            frameImage = ImageUtils.safeSubimage(frameImage, viewportBounds.x, viewportBounds.y, viewportBounds.width, viewportBounds.height);
        }
        Dimension frameSize = new Dimension(frameImage.getWidth(), frameImage.getHeight());
        Rectangle nonEmptyBounds = ImageUtils.getVisibleRegion(frameImage);
        this.frameDimensions.add(frameSize);
        this.frameNonEmptyBounds.add(nonEmptyBounds);
        if (nonEmptyBounds.width == 0 || nonEmptyBounds.height == 0) {
            frameImage = null;
        } else if (!frameSize.equals(nonEmptyBounds.getSize())) {
            frameImage = ImageUtils.safeSubimage(frameImage, nonEmptyBounds.x, nonEmptyBounds.y, nonEmptyBounds.width, nonEmptyBounds.height);
        }
        this.croppedFrameImages.add(frameImage);
    }
}

