/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.animation.AS3Animation;
import com.sodiumarc.patchwork.animation.CompoundAnimation;
import com.sodiumarc.patchwork.animation.CrossMorph;
import com.sodiumarc.patchwork.animation.MoveTransition;
import com.sodiumarc.patchwork.animation.SplitableAnimation;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class SplitAnimation
extends CompoundAnimation {
    public static String ELEMENT_NAME = "split";
    public static String LAYER_IDS_ATTR_NAME = "layer_ids";
    public static DocumentNodeDecoder<SplitAnimation> DECODER = new DocumentNodeDecoder<SplitAnimation>(){

        @Override
        public SplitAnimation decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> properties = XMLUtils.getAttributes(node);
            List<String> splitIDs = Collections.emptyList();
            String splitIDStr = properties.get(LAYER_IDS_ATTR_NAME);
            if (splitIDStr != null) {
                splitIDs = Arrays.asList(splitIDStr.split(","));
            }
            List<SplitableAnimation> splitables = XMLUtils.decodeChildren(node, SPLITABLE_DECODERS);
            return new SplitAnimation(properties.get(AS3Animation.ID_ATTR_NAME), splitables, splitIDs);
        }
    };
    private static Set<DocumentNodeDecoder<? extends SplitableAnimation>> SPLITABLE_DECODERS = new HashSet<DocumentNodeDecoder<? extends SplitableAnimation>>();

    @Deprecated
    public static final <T extends SplitableAnimation> void registerSplitableDecoder(DocumentNodeDecoder<T> decoder) {
        SplitAnimation.getSplitableDecoders().add(decoder);
    }

    public static final Set<DocumentNodeDecoder<? extends SplitableAnimation>> getSplitableDecoders() {
        return Collections.unmodifiableSet(SPLITABLE_DECODERS);
    }

    public SplitAnimation(String id, List<SplitableAnimation> splitables, List<String> layerIDs) {
        super(id);
        ArrayList<AS3Animation> componentAnimations = new ArrayList<AS3Animation>(layerIDs.size() * splitables.size());
        for (SplitableAnimation splitable : splitables) {
            componentAnimations.addAll(splitable.splitByLayer(layerIDs));
        }
        this.setComponentAnimations(componentAnimations);
    }

    static {
        SPLITABLE_DECODERS.add(CrossMorph.DECODER);
        SPLITABLE_DECODERS.add(MoveTransition.DECODER);
    }
}

