/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.animation.InterpolationFunction;
import com.sodiumarc.patchwork.util.MathUtils;

public class SineInterpFunction
implements InterpolationFunction {
    private final double startAngle;
    private final double endAngle;

    public SineInterpFunction(int startQuadrant, int endQuadrant) {
        this.startAngle = 1.5707963267948966 * (double)startQuadrant;
        this.endAngle = 1.5707963267948966 * (double)endQuadrant;
    }

    public SineInterpFunction() {
        this(-1, 1);
    }

    @Override
    public float getInterpFraction(float inputFraction) {
        double angle = MathUtils.interpolate(inputFraction, this.startAngle, this.endAngle);
        return (float)MathUtils.rangeFraction(Math.sin(angle), Math.sin(this.startAngle), Math.sin(this.endAngle));
    }
}

