/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.animation.AS3Animation;
import com.sodiumarc.patchwork.animation.CompoundAnimation;
import com.sodiumarc.patchwork.animation.MultiPropertyKeyframes;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.StringTemplate;
import com.sodiumarc.patchwork.util.StringUtils;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.text.ParseException;
import java.util.Map;
import org.w3c.dom.Node;

@Deprecated
public class SerialAnimation
extends CompoundAnimation {
    public static String ELEMENT_NAME = "serial_anim";
    public static DocumentNodeDecoder<SerialAnimation> DECODER = new DocumentNodeDecoder<SerialAnimation>(){

        @Override
        public SerialAnimation decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> properties = XMLUtils.getAttributes(node);
            SerialAnimation result = new SerialAnimation(properties);
            result.setComponentAnimations(XMLUtils.decodeChildren(node, AS3Animation.getSubclassDecoders()));
            MultiPropertyKeyframes keyframes = (MultiPropertyKeyframes)CollectionUtils.first(XMLUtils.decodeChildren(node, MultiPropertyKeyframes.getSubclassDecoders()));
            result.setContainerKeyframes(keyframes);
            return result;
        }
    };

    public SerialAnimation(Map<String, String> properties) {
        super(properties);
    }

    public SerialAnimation(String id) {
        super(id);
    }

    @Override
    public String toAS3String(TemplateLibrary templates) throws ParseException {
        AS3Animation simplified = this.simplify();
        if (simplified != this) {
            return simplified.toAS3String(templates);
        }
        StringTemplate template = templates.getTemplate(SerialAnimation.class);
        assert (template != null) : "Missing template: " + SerialAnimation.class;
        StringTemplate addToArrayTemplate = templates.getTemplate(AS3Animation.class, "ADD_TO_ARRAY");
        assert (addToArrayTemplate != null) : "Missing template: ADD_TO_ARRAY";
        StringBuilder animDefList = new StringBuilder();
        for (AS3Animation anim : this.getComponentAnimations()) {
            addToArrayTemplate.clearParameterValues();
            addToArrayTemplate.setParameterValue("ANIMATION", anim.toAS3String(templates));
            animDefList.append(addToArrayTemplate.getProcessedText());
        }
        template.setParameterValueQuoted("ID", this.getID());
        template.setParameterValue("ANIMATION_LAYERS", animDefList.toString());
        template.setParameterValue("DURATION_IN_MILLIS", this.durationAsAS3String());
        template.setParameterValueNullable("ALPHA_FUNCTION", this.alphaFunctionAsAS3String(templates));
        template.setParameterValue("ANIMATION_TIMES", StringUtils.toDelimitedList(this.getAnimationTimes(), ","));
        return template.getProcessedText();
    }

    protected double[] getAnimationTimes() {
        int size = this.getComponentAnimations().size();
        double[] result = new double[size];
        for (int i = 0; i < size; ++i) {
            result[i] = i / size;
        }
        return result;
    }
}

