/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.animation.NumericalAlphaFunction;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.Collection.Pair;
import com.sodiumarc.patchwork.util.MathUtils;
import com.sodiumarc.patchwork.util.StringUtils;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class PropertyKeyframes
implements Iterable<Pair<Float, Float>> {
    public static String ELEMENT_NAME = "kf";
    public static String PROPERTY_ATTR_NAME = "property";
    public static String TIMES_ATTR_NAME = "times";
    public static String VALUES_ATTR_NAME = "values";
    public static DocumentNodeDecoder<PropertyKeyframes> DECODER = new DocumentNodeDecoder<PropertyKeyframes>(){

        @Override
        public PropertyKeyframes decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> properties = XMLUtils.getAttributes(node);
            float[] times = StringUtils.decodeFloatArray(properties.get(TIMES_ATTR_NAME), ",");
            float[] values = StringUtils.decodeFloatArray(properties.get(VALUES_ATTR_NAME), ",");
            return new PropertyKeyframes(properties.get(PROPERTY_ATTR_NAME), CollectionUtils.asList(times), CollectionUtils.asList(values));
        }
    };
    private final String propertyName;
    private final ArrayList<Float> times;
    private final ArrayList<Float> values;

    public PropertyKeyframes(String propertyName) {
        this(propertyName, new ArrayList<Float>(), new ArrayList<Float>());
    }

    public PropertyKeyframes(String propertyName, List<Float> times, List<Float> values) {
        this.propertyName = propertyName;
        this.times = new ArrayList<Float>(times);
        this.values = new ArrayList<Float>(values);
        assert (times.size() == values.size()) : "Times and values must have the same length";
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public List<Float> getTimes() {
        return this.times;
    }

    public List<Float> getValues() {
        return this.values;
    }

    public int getKeyframeCount() {
        return this.times.size();
    }

    public Pair<Float, Float> getKeyframe(int index) {
        return new Pair<Float, Float>(this.times.get(index), this.values.get(index));
    }

    public final void addKeyframe(Float time, Float value) {
        this.times.add(time);
        this.values.add(value);
    }

    public final void addKeyframe(Pair<Float, Float> keyframe) {
        this.addKeyframe(keyframe.getFirst(), keyframe.getSecond());
    }

    public final void insertKeyframe(int index, Float time, Float value) {
        this.times.add(index, time);
        this.values.add(index, value);
    }

    public final void insertKeyframe(int index, Pair<Float, Float> keyframe) {
        this.insertKeyframe(index, keyframe.getFirst(), keyframe.getSecond());
    }

    public void applyAlphaFunc(NumericalAlphaFunction func, int beforeIndex) {
        assert (beforeIndex > 0) : "beforeIndex must be > 0";
        Pair<Float, Float> start = this.getKeyframe(beforeIndex - 1);
        Pair<Float, Float> end = this.getKeyframe(beforeIndex);
        List<Float> funcInputs = func.getInputValues();
        List<Float> funcOutputs = func.getOutputValues();
        for (int i = funcInputs.size() - 1; i >= 0; --i) {
            float input = funcInputs.get(i).floatValue();
            float output = funcOutputs.get(i).floatValue();
            if (input == 0.0f && output == 0.0f || input == 1.0f && output == 1.0f) continue;
            float newTime = (float)MathUtils.interpolate(input, start.getFirst().floatValue(), end.getFirst().floatValue());
            float newValue = (float)MathUtils.interpolate(output, start.getSecond().floatValue(), end.getSecond().floatValue());
            this.insertKeyframe(beforeIndex, Float.valueOf(newTime), Float.valueOf(newValue));
        }
    }

    @Override
    public Iterator<Pair<Float, Float>> iterator() {
        final Iterator<Float> timesIter = this.times.iterator();
        final Iterator<Float> valuesIter = this.values.iterator();
        return new Iterator<Pair<Float, Float>>(){

            @Override
            public boolean hasNext() {
                return timesIter.hasNext();
            }

            @Override
            public Pair<Float, Float> next() {
                return new Pair<Float, Float>((Float)timesIter.next(), (Float)valuesIter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [propertyName=" + this.propertyName + ", times=" + this.times + ", values=" + this.values + "]";
    }
}

