/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.animation.AlphaFunction;
import com.sodiumarc.patchwork.app.scenecomposer.as3.AS3ConversionUtils;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.StringTemplate;
import com.sodiumarc.patchwork.util.StringUtils;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class NumericalAlphaFunction
extends AlphaFunction {
    public static String ELEMENT_NAME = "numeric_alpha";
    public static String INPUT_VALUES_ATTR_NAME = "input_values";
    public static String OUTPUT_VALUES_ATTR_NAME = "output_values";
    public static final NumericalAlphaFunction REVERSE = new NumericalAlphaFunction(CollectionUtils.asList(0.0f, 1.0f), CollectionUtils.asList(1.0f, 0.0f));
    private final List<Float> inputValues = new ArrayList<Float>();
    private final List<Float> outputValues = new ArrayList<Float>();

    public static NumericalAlphaFunction createRamp(float rampStart, float rampEnd) {
        assert (rampStart <= rampEnd) : "rampStart > rampEnd";
        ArrayList<Float> inputValues = new ArrayList<Float>();
        ArrayList<Float> outputValues = new ArrayList<Float>();
        if (rampStart > 0.0f) {
            inputValues.add(Float.valueOf(0.0f));
            outputValues.add(Float.valueOf(0.0f));
        }
        inputValues.add(Float.valueOf(rampStart));
        outputValues.add(Float.valueOf(0.0f));
        inputValues.add(Float.valueOf(rampEnd));
        outputValues.add(Float.valueOf(1.0f));
        if (rampEnd < 1.0f) {
            inputValues.add(Float.valueOf(1.0f));
            outputValues.add(Float.valueOf(1.0f));
        }
        return new NumericalAlphaFunction(inputValues, outputValues);
    }

    public static NumericalAlphaFunction createRamp(String encodedForm) {
        String[] components = encodedForm.split(",");
        assert (components.length == 2) : "Wrong number of components: " + components.length;
        return NumericalAlphaFunction.createRamp(Float.valueOf(components[0]).floatValue(), Float.valueOf(components[1]).floatValue());
    }

    public NumericalAlphaFunction() {
    }

    public NumericalAlphaFunction(List<Float> inputValues, List<Float> outputValues) {
        this();
        this.setValues(inputValues, outputValues);
    }

    public void setValues(List<Float> inputValues, List<Float> outputValues) {
        assert (inputValues != null && inputValues.size() > 0) : "Invalid inputValues: " + inputValues;
        assert (outputValues != null && outputValues.size() > 0) : "Invalid outputValues: " + outputValues;
        assert (inputValues.size() == outputValues.size()) : "Input and output values must be of the same length";
        this.inputValues.clear();
        this.inputValues.addAll(inputValues);
        this.outputValues.clear();
        this.outputValues.addAll(outputValues);
    }

    public void setEvenlySpacedOutputs(List<Float> outputValues) {
        assert (outputValues != null && outputValues.size() > 0) : "Invalid outputValues: " + outputValues;
        ArrayList<Float> inputValues = new ArrayList<Float>(outputValues.size());
        int n = outputValues.size() - 1;
        for (int i = 0; i < n; ++i) {
            inputValues.add(Float.valueOf((float)i / (float)n));
        }
        inputValues.add(Float.valueOf(1.0f));
        this.setValues(inputValues, outputValues);
    }

    public void setLoops(int loops) {
        ArrayList<Float> inputValues = new ArrayList<Float>(2 * loops);
        ArrayList<Float> outputValues = new ArrayList<Float>(2 * loops);
        float loopStep = 1.0f / (float)loops;
        float loopStart = 0.0f;
        for (int i = 0; i < loops; ++i) {
            inputValues.add(Float.valueOf(loopStart));
            outputValues.add(Float.valueOf(0.0f));
            inputValues.add(Float.valueOf(Math.min(1.0f, loopStart + loopStep)));
            outputValues.add(Float.valueOf(1.0f));
            loopStart += loopStep;
        }
        this.setValues(inputValues, outputValues);
    }

    public List<Float> getInputValues() {
        return this.inputValues;
    }

    public List<Float> getOutputValues() {
        return this.outputValues;
    }

    @Override
    public String toAS3String(TemplateLibrary templates) throws ParseException {
        StringTemplate template = templates.getTemplate(this.getClass());
        assert (template != null) : "Missing template: " + this.getClass();
        template.setParameterValue("INPUT_VALUES", AS3ConversionUtils.toArrayLiteral(this.inputValues));
        template.setParameterValue("OUTPUT_VALUES", AS3ConversionUtils.toArrayLiteral(this.outputValues));
        return template.getProcessedText();
    }

    public static class Decoder
    implements DocumentNodeDecoder<NumericalAlphaFunction> {
        @Override
        public NumericalAlphaFunction decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> properties = XMLUtils.getAttributes(node);
            List<Float> inputValues = CollectionUtils.asList(StringUtils.decodeFloatArray(properties.get(INPUT_VALUES_ATTR_NAME)));
            List<Float> outputValues = CollectionUtils.asList(StringUtils.decodeFloatArray(properties.get(OUTPUT_VALUES_ATTR_NAME)));
            return new NumericalAlphaFunction(inputValues, outputValues);
        }
    }
}

