/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.animation.ImportedKeyframes;
import com.sodiumarc.patchwork.animation.InlineKeyframes;
import com.sodiumarc.patchwork.animation.KeyframesInstance;
import com.sodiumarc.patchwork.animation.PropertyKeyframes;
import com.sodiumarc.patchwork.app.scenecomposer.as3.AS3ConversionUtils;
import com.sodiumarc.patchwork.app.scenecomposer.as3.AS3Convertible;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.util.Collection.Pair;
import com.sodiumarc.patchwork.util.StringTemplate;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MultiPropertyKeyframes
implements AS3Convertible {
    private final String id;
    private final Map<String, PropertyKeyframes> keyframesByPropertyName;
    private static Set<DocumentNodeDecoder<? extends MultiPropertyKeyframes>> SUBCLASS_DECODERS = new HashSet<DocumentNodeDecoder<? extends MultiPropertyKeyframes>>();

    public static final Set<DocumentNodeDecoder<? extends MultiPropertyKeyframes>> getSubclassDecoders() {
        return Collections.unmodifiableSet(SUBCLASS_DECODERS);
    }

    public MultiPropertyKeyframes(String id) {
        this.id = id;
        this.keyframesByPropertyName = new HashMap<String, PropertyKeyframes>();
    }

    public String getID() {
        return this.id;
    }

    public Set<String> getPropertyNames() {
        return this.keyframesByPropertyName.keySet();
    }

    public final void setKeyframes(String propertyName, PropertyKeyframes keyframes) {
        this.keyframesByPropertyName.put(propertyName, keyframes);
    }

    public final void addKeyframe(String propertyName, Float time, Float value) {
        if (!this.keyframesByPropertyName.containsKey(propertyName)) {
            this.keyframesByPropertyName.put(propertyName, new PropertyKeyframes(propertyName));
        }
        this.keyframesByPropertyName.get(propertyName).addKeyframe(time, value);
    }

    public final void addKeyframe(String propertyName, Pair<Float, Float> keyframe) {
        this.addKeyframe(propertyName, keyframe.getFirst(), keyframe.getSecond());
    }

    public PropertyKeyframes getKeyframes(String propertyName) {
        return this.keyframesByPropertyName.get(propertyName);
    }

    @Override
    public String toAS3String(TemplateLibrary templates) throws ParseException {
        StringTemplate template = templates.getTemplate(MultiPropertyKeyframes.class);
        assert (template != null) : "Missing template: " + MultiPropertyKeyframes.class;
        StringTemplate addKeyframesTemplate = templates.getTemplate(MultiPropertyKeyframes.class, "ADD_KEYFRAMES");
        assert (addKeyframesTemplate != null) : "Missing template: ADD_KEYFRAMES";
        StringBuilder addKeyframes = new StringBuilder();
        for (Map.Entry<String, PropertyKeyframes> entry : this.keyframesByPropertyName.entrySet()) {
            PropertyKeyframes keyframes = entry.getValue();
            addKeyframesTemplate.clearParameterValues();
            addKeyframesTemplate.setParameterValueQuoted("PROPERTY_NAME", entry.getKey());
            addKeyframesTemplate.setParameterValue("INPUTS", AS3ConversionUtils.toArrayLiteral(keyframes.getTimes()));
            addKeyframesTemplate.setParameterValue("OUTPUTS", AS3ConversionUtils.toArrayLiteral(keyframes.getValues()));
            addKeyframes.append(addKeyframesTemplate.getProcessedText());
        }
        template.setParameterValue("ADD_KEYFRAMES", addKeyframes.toString());
        return template.getProcessedText();
    }

    static {
        SUBCLASS_DECODERS.add(new ImportedKeyframes.Decoder());
        SUBCLASS_DECODERS.add(new KeyframesInstance.Decoder());
        SUBCLASS_DECODERS.add(new InlineKeyframes.Decoder());
    }
}

