/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.animation.AS3Animation;
import com.sodiumarc.patchwork.animation.AdjustableRampFunction;
import com.sodiumarc.patchwork.animation.CompoundAlphaFunction;
import com.sodiumarc.patchwork.animation.CompoundAnimation;
import com.sodiumarc.patchwork.animation.CrossMorph;
import com.sodiumarc.patchwork.animation.NumericalAlphaFunction;
import com.sodiumarc.patchwork.animation.SerialSequencer;
import com.sodiumarc.patchwork.animation.SplitableAnimation;
import com.sodiumarc.patchwork.animation.StillImage;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.render.BoundingBox3D;
import com.sodiumarc.patchwork.render.control.RenderControl;
import com.sodiumarc.patchwork.render.control.RenderImage;
import com.sodiumarc.patchwork.render.mesh.Plane;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.render.scenegraph.Transform3D;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.GeometricAxis;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class MoveTransition
extends CompoundAnimation
implements SplitableAnimation {
    public static String ELEMENT_NAME = "move_transition";
    public static String IMAGE_PATTERNS_ATTR_NAME = "image_patterns";
    public static String IMAGE_PATTERN_ATTR_NAME = "image_pattern";
    public static String LAYER_IDS_ATTR_NAME = "layer_ids";
    public static String DOMINANT_LAYER_ATTR_NAME = "dominant_layer_id";
    public static String FROM_RAMP_ATTR_NAME = "from_ramp";
    public static String TO_RAMP_ATTR_NAME = "to_ramp";
    public static DocumentNodeDecoder<MoveTransition> DECODER = new DocumentNodeDecoder<MoveTransition>(){

        @Override
        public MoveTransition decode(Node node) {
            String fromRampStr;
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> properties = XMLUtils.getAttributes(node);
            String layerIDStr = properties.get(LAYER_IDS_ATTR_NAME);
            List<String> layerIDList = layerIDStr == null ? null : Arrays.asList(layerIDStr.split(","));
            String dominantLayerID = properties.get(DOMINANT_LAYER_ATTR_NAME);
            ArrayList<RenderImage> transitionImages = new ArrayList<RenderImage>();
            String imagePatterns = properties.get(IMAGE_PATTERNS_ATTR_NAME);
            if (imagePatterns != null) {
                String[] imagePatternsSplit;
                String imageBase = RenderImage.getImageBase(node);
                for (String imagePattern : imagePatternsSplit = imagePatterns.split(",")) {
                    List<RenderImage> matching;
                    imagePattern = imagePattern.trim();
                    String completePattern = imageBase == null ? imagePattern : Pattern.quote(imageBase + ".") + imagePattern;
                    try {
                        matching = RenderControl.getInstance().getAllMatching(completePattern, layerIDList, dominantLayerID);
                    }
                    catch (Exception e) {
                        Logger.getLogger(this.getClass()).warn("Decode failed: ", e);
                        return null;
                    }
                    if (matching.isEmpty()) {
                        Logger.getLogger(MoveTransition.class).warn("No matches found for pattern: " + completePattern + " " + layerIDList);
                    }
                    transitionImages.addAll(matching);
                }
            } else {
                for (StillImage stillImage : XMLUtils.decodeChildren(node, StillImage.DECODER)) {
                    RenderImage ri = CollectionUtils.first(stillImage.getImages(true));
                    CollectionUtils.addIfNotNull(transitionImages, ri);
                }
            }
            NumericalAlphaFunction fromRamp = (fromRampStr = properties.get(FROM_RAMP_ATTR_NAME)) == null ? null : NumericalAlphaFunction.createRamp(fromRampStr);
            String toRampStr = properties.get(TO_RAMP_ATTR_NAME);
            NumericalAlphaFunction toRamp = toRampStr == null ? null : NumericalAlphaFunction.createRamp(toRampStr);
            MoveTransition result = new MoveTransition(properties, transitionImages, fromRamp, toRamp);
            return result;
        }
    };
    private final List<RenderImage> transitionImages;
    private final NumericalAlphaFunction fromRamp;
    private final NumericalAlphaFunction toRamp;
    private boolean animationInitialized = false;
    private static final double LATERAL_MOVEMENT_THRESHOLD = 0.01;
    private static final int ALPHA_INTERPOLATION_STEPS = 12;

    public MoveTransition(Map<String, String> properties, List<RenderImage> transitionImages, NumericalAlphaFunction fromRamp, NumericalAlphaFunction toRamp) {
        super(properties);
        assert (transitionImages.size() >= 2) : "Too few transition images:" + transitionImages.size();
        this.transitionImages = transitionImages;
        this.fromRamp = fromRamp;
        this.toRamp = toRamp;
    }

    public MoveTransition(String id, List<RenderImage> transitionImages, NumericalAlphaFunction fromRamp, NumericalAlphaFunction toRamp) {
        super(id);
        this.transitionImages = transitionImages;
        this.fromRamp = fromRamp;
        this.toRamp = toRamp;
    }

    @Override
    public String toAS3String(TemplateLibrary templates) throws ParseException {
        this.initAnimation();
        return super.toAS3String(templates);
    }

    @Override
    public List<AS3Animation> splitByLayer(List<String> layerPatterns) {
        ArrayList<AS3Animation> result = new ArrayList<AS3Animation>();
        if (this.transitionImages.isEmpty()) {
            return result;
        }
        List<String> layerIDs = CollectionUtils.first(this.transitionImages).getMatchingLayerIDs(layerPatterns);
        for (String layerID : layerIDs) {
            ArrayList<RenderImage> splitTransitionImages = new ArrayList<RenderImage>();
            for (RenderImage image : this.transitionImages) {
                RenderImage layerImage = null;
                try {
                    layerImage = RenderControl.getInstance().getLayerImage(image, layerID, RenderControl.DEFAULT_CONDITION);
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass()).warn("Failed to load layer image: " + layerID);
                }
                CollectionUtils.addIfNotNull(splitTransitionImages, layerImage);
            }
            String splitID = this.getID() + "_" + layerID;
            MoveTransition transition = new MoveTransition(splitID, splitTransitionImages, this.fromRamp, this.toRamp);
            transition.setDurationInMillis(this.getDurationInMillis());
            result.add(transition);
        }
        return result;
    }

    @Override
    public Set<RenderImage> getImages(boolean renderableOnly) {
        HashSet<RenderImage> result = new HashSet<RenderImage>();
        for (RenderImage image : this.transitionImages) {
            if (renderableOnly && image.isEmpty()) continue;
            result.add(image);
        }
        return result;
    }

    private void initAnimation() {
        if (this.animationInitialized) {
            return;
        }
        assert (this.transitionImages.size() >= 2) : "Too few transition images:" + this.transitionImages;
        ArrayList<AS3Animation> componentAnimations = new ArrayList<AS3Animation>();
        ArrayList<Double> distances = new ArrayList<Double>();
        double totalDistance = 0.0;
        for (int i = 0; i < this.transitionImages.size() - 1; ++i) {
            AS3Animation stepAnim;
            RenderImage fromImage = this.transitionImages.get(i);
            RenderImage toImage = this.transitionImages.get(i + 1);
            Camera fromCamera = fromImage.getCamera();
            Camera toCamera = toImage.getCamera();
            assert (fromCamera != null) : "No camera defined for image: " + fromImage;
            assert (toCamera != null) : "No camera defined for image: " + toImage;
            assert (fromImage.getReferenceBounds3D() != null) : "No reference bounds defined for image: " + fromImage.getName();
            double distanceSoFar = totalDistance;
            totalDistance += fromCamera.getGlobalPosition().distance(toCamera.getGlobalPosition());
            boolean isForward = this.isForwardMovement(fromCamera, toCamera);
            RenderImage backImage = isForward ? fromImage : toImage;
            RenderImage frontImage = isForward ? toImage : fromImage;
            double clipFraction = this.computeReferenceClipFraction(backImage, frontImage);
            double startFraction = 0.0;
            double endFraction = 1.0;
            if (clipFraction < 0.0) {
                stepAnim = new StillImage(null, null);
            } else if (clipFraction > 1.0) {
                stepAnim = CrossMorph.newReferenceAlignmentInstance(null, fromImage, toImage, this.fromRamp, this.toRamp);
            } else {
                Rectangle4d interpolatedRefRect = this.computeInterpolatedReferenceRectangle(backImage, frontImage, clipFraction);
                Rectangle4d fromRect = null;
                Rectangle4d toRect = null;
                if (isForward) {
                    startFraction = 0.0;
                    endFraction = clipFraction;
                    fromRect = fromImage.getReferenceRectangle(true);
                    toRect = interpolatedRefRect;
                } else {
                    startFraction = 1.0 - clipFraction;
                    endFraction = 1.0;
                    fromRect = interpolatedRefRect;
                    toRect = toImage.getReferenceRectangle(true);
                }
                StillImage fromAnim = fromImage == null || fromImage.isEmpty() ? null : new StillImage(null, fromImage);
                StillImage toAnim = toImage == null || toImage.isEmpty() ? null : new StillImage(null, toImage);
                stepAnim = new CrossMorph(this.getID() + "-CrossMorph" + i, fromAnim, toAnim, fromRect, toRect, this.fromRamp, this.toRamp);
                stepAnim.setAlphaFunction(new AdjustableRampFunction(startFraction, endFraction));
            }
            AdjustableRampFunction rampFunc = new AdjustableRampFunction(startFraction, endFraction);
            if (this.isLateralMovement(fromCamera, toCamera)) {
                stepAnim.setAlphaFunction(rampFunc);
            } else {
                NumericalAlphaFunction numericalFunc = this.computeNumericalAlphaFunction(fromImage, toImage, startFraction, endFraction, 12);
                stepAnim.setAlphaFunction(new CompoundAlphaFunction(Arrays.asList(rampFunc, numericalFunc)));
            }
            componentAnimations.add(stepAnim);
            distances.add(distanceSoFar);
        }
        this.setComponentAnimations(componentAnimations);
        ArrayList<Double> animationTimes = new ArrayList<Double>(distances.size());
        for (int i = 0; i < distances.size(); ++i) {
            animationTimes.add((Double)distances.get(i) / totalDistance);
        }
        this.setSequencer(new SerialSequencer(animationTimes));
        this.animationInitialized = true;
    }

    private boolean isForwardMovement(Camera fromCamera, Camera toCamera) {
        Vector3d v = fromCamera.getGlobalViewVector();
        Vector3d d = new Vector3d(toCamera.getGlobalPosition());
        d.sub(fromCamera.getGlobalPosition());
        d.normalize();
        return v.dot(d) > 0.0;
    }

    private boolean isLateralMovement(Camera fromCamera, Camera toCamera) {
        Vector3d v = fromCamera.getGlobalViewVector();
        Vector3d d = new Vector3d(toCamera.getGlobalPosition());
        d.sub(fromCamera.getGlobalPosition());
        d.normalize();
        return Math.abs(v.dot(d)) < 0.01;
    }

    private double computeReferenceClipFraction(RenderImage fromImage, RenderImage toImage) {
        Camera fromCamera = fromImage.getCamera();
        Camera toCamera = toImage.getCamera();
        Point3d fromPosition = new Point3d(fromCamera.getGlobalPosition());
        Point3d toPosition = new Point3d(toCamera.getGlobalPosition());
        Vector3d clipPoint = new Vector3d(0.0, 0.0, fromImage.getNearClipDistance());
        clipPoint = fromCamera.fromCameraCoords(clipPoint);
        double clipDistance = clipPoint.length();
        Vector3d viewVector = fromCamera.getGlobalViewVector();
        Vector3d offsetVector = new Vector3d(viewVector);
        offsetVector.scale(clipDistance);
        fromPosition.add(offsetVector);
        toPosition.add(offsetVector);
        Plane fromPlane = new Plane(fromPosition, viewVector);
        BoundingBox3D box = fromImage.getReferenceBounds3D();
        Point3d refPoint = new Point3d(box.getCenterPoint());
        refPoint.z = box.getRange(GeometricAxis.Z).getMin();
        refPoint = fromCamera.fromCameraCoords(refPoint);
        double fromDist = fromPlane.pointDistance(refPoint);
        double totalDist = fromPlane.pointDistance(toPosition);
        return fromDist / totalDist;
    }

    private Rectangle4d computeInterpolatedReferenceRectangle(RenderImage fromImage, RenderImage toImage, double interpFraction) {
        Camera fromCamera = fromImage.getCamera();
        Camera toCamera = toImage.getCamera();
        BoundingBox3D refBox = fromImage.getReferenceBounds3D();
        Vector3d translation = new Vector3d(toCamera.getGlobalPosition());
        translation.sub(fromCamera.getGlobalPosition());
        translation.scale(interpFraction);
        Transform3D cumulativeTransform = new Transform3D();
        cumulativeTransform.setTranslation(translation);
        cumulativeTransform.mul(fromCamera.getCumulativeTransform());
        Camera interpCam = new Camera(null, cumulativeTransform);
        List<Point3d> boxPoints = refBox.getAllCornerPoints();
        ArrayList<Point3d> newBoxPoints = new ArrayList<Point3d>(boxPoints.size());
        for (Point3d point : boxPoints) {
            newBoxPoints.add(interpCam.globalToCamera(fromCamera.fromCameraCoords(point)));
        }
        Rectangle4d projectedRefRect = interpCam.getProjectedBounds((Iterable<Point3d>)newBoxPoints);
        return fromImage.getProjectedBounds().toProportional(projectedRefRect);
    }

    private NumericalAlphaFunction computeNumericalAlphaFunction(RenderImage fromImage, RenderImage toImage, double startFraction, double endFraction, int steps) {
        Rectangle4d startRect = this.computeInterpolatedReferenceRectangle(fromImage, toImage, startFraction);
        Rectangle4d endRect = this.computeInterpolatedReferenceRectangle(fromImage, toImage, endFraction);
        double widthRange = endRect.getWidth() - startRect.getWidth();
        float[] outputValues = new float[steps + 1];
        outputValues[0] = 0.0f;
        outputValues[steps] = 1.0f;
        double stepSize = (endFraction - startFraction) / (double)steps;
        double currentFraction = startFraction + stepSize;
        for (int i = 1; i < steps; ++i) {
            Rectangle4d rect = this.computeInterpolatedReferenceRectangle(fromImage, toImage, currentFraction);
            double widthChange = rect.getWidth() - startRect.getWidth();
            outputValues[i] = (float)(widthChange / widthRange);
            currentFraction += stepSize;
        }
        NumericalAlphaFunction result = new NumericalAlphaFunction();
        result.setEvenlySpacedOutputs(CollectionUtils.asList(outputValues));
        return result;
    }
}

