/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.animation.MultiPropertyKeyframes;
import com.sodiumarc.patchwork.animation.PropertyKeyframes;
import com.sodiumarc.patchwork.collada.COLLADA;
import com.sodiumarc.patchwork.generate.Card;
import com.sodiumarc.patchwork.render.RenderResourceIO;
import com.sodiumarc.patchwork.render.mesh.PolyMesh3D;
import com.sodiumarc.patchwork.render.scenegraph.AnimatableTransform;
import com.sodiumarc.patchwork.render.scenegraph.COLLADALoader;
import com.sodiumarc.patchwork.render.scenegraph.Camera;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraph;
import com.sodiumarc.patchwork.render.scenegraph.SceneGraphNode;
import com.sodiumarc.patchwork.render.scenegraph.TransformAnimator;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.GeometricAxis;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.VectorUtils;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ImportedKeyframes
extends MultiPropertyKeyframes {
    public static String ELEMENT_NAME = "import_keyframes";
    public static String ID_ATTR_NAME = "id";
    public static String FILENAME_ATTR_NAME = "filename";
    public static String NODE_NAME_ATTR_NAME = "node_name";
    public static String CAMERA_ID_ATTR_NAME = "camera_id";
    public static String FRAME_MESH_ID_ATTR_NAME = "frame_mesh_id";
    private static final Set<AnimatableTransform.Channel> VECTOR_CHANNELS = EnumSet.of(AnimatableTransform.Channel.TRANSLATION, AnimatableTransform.Channel.SCALE);
    private static final Set<AnimatableTransform.Channel> SCALAR_CHANNELS = EnumSet.of(AnimatableTransform.Channel.Z_ROTATION);
    private static final Set<GeometricAxis> AXES = EnumSet.of(GeometricAxis.X, GeometricAxis.Y);

    public ImportedKeyframes(String id, String filename, String nodeName, String cameraID, String frameMeshID) throws IOException, SAXException, ParserConfigurationException {
        super(id);
        COLLADA inputRoot = RenderResourceIO.getInstance().getCOLLADA(filename);
        SceneGraph sceneGraph = new COLLADALoader().load(inputRoot);
        Set<SceneGraphNode> nodes = sceneGraph.getNodes(nodeName);
        assert (nodes.size() < 2) : "Found multiple nodes named \"" + nodeName + "\"";
        assert (nodes.size() > 0) : "No node named \"" + nodeName + "\"";
        SceneGraphNode node = CollectionUtils.first(nodes);
        Camera camera = sceneGraph.getCamera(cameraID);
        assert (camera != null) : "No camera \"" + cameraID + "\"";
        PolyMesh3D frameMesh = sceneGraph.getMeshInCameraCoords(frameMeshID, cameraID);
        Rectangle4d frameBounds = camera.getProjectedBounds(frameMesh);
        for (AnimatableTransform.Channel channel : VECTOR_CHANNELS) {
            for (GeometricAxis axis : AXES) {
                this.readKeyframes(node, channel, axis, camera, frameBounds, false);
            }
        }
        for (AnimatableTransform.Channel channel : SCALAR_CHANNELS) {
            this.readKeyframes(node, channel, null, camera, frameBounds, false);
        }
    }

    private void readKeyframes(SceneGraphNode node, AnimatableTransform.Channel channel, GeometricAxis axis, Camera camera, Rectangle4d bounds, boolean relativeToStart) {
        String propertyName = this.getAS3PropertyName(channel, axis);
        assert (propertyName != null) : "Invalid channel or axis";
        PropertyKeyframes keyframes = new PropertyKeyframes(propertyName);
        TransformAnimator<?> animator = node.getAnimatableTransform().getAnimator(channel);
        if (animator == null) {
            return;
        }
        if (channel == AnimatableTransform.Channel.TRANSLATION) {
            Point3d initialPosition = null;
            for (Double frame : animator.getKeyframes()) {
                Vector3d vectorValue = (Vector3d)animator.getValueAt(frame);
                Point3d adjustedPosition = this.toCardPixelCoords(vectorValue, camera, bounds);
                if (initialPosition == null) {
                    initialPosition = new Point3d(adjustedPosition);
                }
                if (relativeToStart) {
                    adjustedPosition.sub(initialPosition);
                }
                keyframes.addKeyframe(Float.valueOf(frame.floatValue()), Float.valueOf((float)VectorUtils.getComponent(adjustedPosition, axis)));
            }
        } else if (channel == AnimatableTransform.Channel.SCALE) {
            for (Double frame : animator.getKeyframes()) {
                Vector3d vectorValue = (Vector3d)animator.getValueAt(frame);
                keyframes.addKeyframe(Float.valueOf(frame.floatValue()), Float.valueOf((float)VectorUtils.getComponent(vectorValue, axis)));
            }
        } else if (channel == AnimatableTransform.Channel.Z_ROTATION) {
            Double initialValue = null;
            for (Double frame : animator.getKeyframes()) {
                Double scalarValue = (Double)animator.getValueAt(frame);
                if (initialValue == null) {
                    initialValue = scalarValue;
                }
                if (relativeToStart) {
                    scalarValue = scalarValue - initialValue;
                }
                keyframes.addKeyframe(Float.valueOf(frame.floatValue()), Float.valueOf((float)(-scalarValue.doubleValue())));
            }
        }
        this.setKeyframes(propertyName, keyframes);
    }

    private String getAS3PropertyName(AnimatableTransform.Channel channel, GeometricAxis axis) {
        switch (channel) {
            case SCALE: {
                switch (axis) {
                    case X: {
                        return "scaleX";
                    }
                    case Y: {
                        return "scaleY";
                    }
                }
                return null;
            }
            case Z_ROTATION: {
                return "rotation";
            }
            case TRANSLATION: {
                switch (axis) {
                    case X: {
                        return "x";
                    }
                    case Y: {
                        return "y";
                    }
                }
                return null;
            }
        }
        return null;
    }

    private Point3d toCardPixelCoords(Tuple3d position, Camera camera, Rectangle4d bounds) {
        Point3d result = camera.globalToCamera(new Point3d(position));
        result = camera.cameraToProjected(result);
        result = camera.projectedToDisplay(result, bounds, Card.CARD_DIMENSION, new Point3d());
        return result;
    }

    public static class Decoder
    implements DocumentNodeDecoder<ImportedKeyframes> {
        @Override
        public ImportedKeyframes decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> properties = XMLUtils.getAttributes(node);
            try {
                return new ImportedKeyframes(properties.get(ID_ATTR_NAME), properties.get(FILENAME_ATTR_NAME), properties.get(NODE_NAME_ATTR_NAME), properties.get(CAMERA_ID_ATTR_NAME), properties.get(FRAME_MESH_ID_ATTR_NAME));
            }
            catch (Exception e) {
                Logger.getLogger(ImportedKeyframes.class).warn("Decode failed", e);
                e.printStackTrace();
                return null;
            }
        }
    }
}

