/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.animation.AS3Animation;
import com.sodiumarc.patchwork.animation.SpriteSheetAnimation;
import com.sodiumarc.patchwork.app.scenecomposer.as3.AS3ConversionUtils;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.generate.Card;
import com.sodiumarc.patchwork.render.HoleMap;
import com.sodiumarc.patchwork.render.control.RenderImage;
import com.sodiumarc.patchwork.render.control.RenderImageProperty;
import com.sodiumarc.patchwork.util.Collection.Range;
import com.sodiumarc.patchwork.util.StringTemplate;
import com.sodiumarc.patchwork.util.StringUtils;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.awt.Point;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class ImportedAnimation
extends AS3Animation {
    public static String ELEMENT_NAME = "import_anim";
    public static String IMPORT_NAME_ATTR_NAME = "import_name";
    public static String FRAME_RANGE_ATTR_NAME = "frame_range";
    public static String NUDGE_ATTR_NAME = "nudge";
    public static String DURATION_SCALE_ATTR_NAME = "duration_scale";
    public static DocumentNodeDecoder<ImportedAnimation> DECODER = new DocumentNodeDecoder<ImportedAnimation>(){

        @Override
        public ImportedAnimation decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> properties = XMLUtils.getAttributes(node);
            return new ImportedAnimation(properties);
        }
    };
    private final String importName;
    private final Point nudge;
    private final float durationScale;
    private final Range<Integer> frameRange;
    private final String export_id;
    private SpriteSheetAnimation animSheet;
    private RenderImage renderImage;
    private static final String ID_PREFIX = "IAS_";

    public ImportedAnimation(Map<String, String> properties) {
        super(properties);
        this.importName = properties.get(IMPORT_NAME_ATTR_NAME);
        Range<Integer> frameRange = Range.decodeIntegerRange(properties.get(FRAME_RANGE_ATTR_NAME));
        if (frameRange == null) {
            frameRange = new Range<Integer>(-1, -1);
        }
        this.frameRange = frameRange;
        Point nudge = StringUtils.decodePoint(properties.get(NUDGE_ATTR_NAME));
        if (nudge == null) {
            nudge = new Point(0, 0);
        }
        this.nudge = nudge;
        this.durationScale = Float.valueOf(properties.get(DURATION_SCALE_ATTR_NAME)).floatValue();
        this.export_id = ID_PREFIX + this.importName;
    }

    @Override
    public Set<RenderImage> getImages(boolean renderableOnly) {
        return Collections.singleton(this.getRenderImage());
    }

    @Override
    public String toAS3String(TemplateLibrary templates) throws ParseException {
        StringTemplate template = templates.getTemplate(this.getClass());
        assert (template != null) : "Missing template: " + this.getClass();
        SpriteSheetAnimation animSheet = this.getAnimSheet();
        Point gridSize = new Point(animSheet.getColumnCount(), animSheet.getRowCount());
        ArrayList<String> offsetPoints = new ArrayList<String>();
        for (Point frameOffset : animSheet.getFrameOffsets()) {
            Point nudgedOffset = new Point(frameOffset.x + this.nudge.x, frameOffset.y + this.nudge.y);
            offsetPoints.add(AS3ConversionUtils.createPointDeclaration(nudgedOffset));
        }
        template.setParameterValueQuoted("ID", this.getID());
        template.setParameterValueQuoted("IMPORT_NAME", this.getRenderImage().getImageFilename());
        template.setParameterValue("GRID_SIZE", AS3ConversionUtils.createPointDeclaration(gridSize));
        template.setParameterValue("FRAME_OFFSETS", StringUtils.toDelimitedList(offsetPoints, ","));
        template.setParameterValue((Object)"START_FRAME", this.frameRange.getMin().intValue());
        template.setParameterValue((Object)"END_FRAME", this.frameRange.getMax().intValue());
        template.setParameterValue((Object)"DURATION_IN_MILLIS", (long)(this.durationScale * (float)animSheet.getDurationInMillis()));
        return template.getProcessedText();
    }

    private RenderImage getRenderImage() {
        if (this.renderImage == null) {
            this.renderImage = new RenderImage(this.export_id, null, this.getAnimSheet().getSheetImage(), new HoleMap(), new EnumMap<RenderImageProperty, String>(RenderImageProperty.class));
        }
        return this.renderImage;
    }

    private SpriteSheetAnimation getAnimSheet() {
        if (this.animSheet == null) {
            try {
                this.animSheet = SpriteSheetAnimation.get(this.importName, Card.CARD_DIMENSION);
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass()).warn("Failed to load snimation sheet: " + this.importName);
            }
            assert (this.animSheet != null) : "Failed to load snimation sheet: " + this.importName;
        }
        return this.animSheet;
    }
}

