/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.animation.AS3Animation;
import com.sodiumarc.patchwork.animation.AnimationUtils;
import com.sodiumarc.patchwork.animation.CompoundAnimation;
import com.sodiumarc.patchwork.animation.MultiPropertyKeyframes;
import com.sodiumarc.patchwork.animation.NumericalAlphaFunction;
import com.sodiumarc.patchwork.animation.SplitableAnimation;
import com.sodiumarc.patchwork.animation.StillImage;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.generate.Card;
import com.sodiumarc.patchwork.render.control.ImageOutputID;
import com.sodiumarc.patchwork.render.control.RenderControl;
import com.sodiumarc.patchwork.render.control.RenderImage;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.Rectangle4d;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class CrossMorph
extends CompoundAnimation
implements SplitableAnimation {
    public static String ELEMENT_NAME = "cross_morph";
    public static String FROM_NAME_ATTR_NAME = "from_name";
    public static String TO_NAME_ATTR_NAME = "to_name";
    public static String FROM_RAMP_ATTR_NAME = "from_ramp";
    public static String TO_RAMP_ATTR_NAME = "to_ramp";
    public static String LAYER_IDS_ATTR_NAME = "layer_ids";
    public static String DOMINANT_LAYER_ATTR_NAME = "dominant_layer_id";
    public static DocumentNodeDecoder<CrossMorph> DECODER = new DocumentNodeDecoder<CrossMorph>(){

        @Override
        public CrossMorph decode(Node node) {
            RenderImage toImage;
            RenderImage fromImage;
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> properties = XMLUtils.getAttributes(node);
            String id = properties.get(AS3Animation.ID_ATTR_NAME);
            String fromImageName = RenderImage.completeImageName(properties.get(FROM_NAME_ATTR_NAME), node);
            String toImageName = RenderImage.completeImageName(properties.get(TO_NAME_ATTR_NAME), node);
            String layerIDStr = properties.get(LAYER_IDS_ATTR_NAME);
            List<String> layerIDList = layerIDStr == null ? null : Arrays.asList(layerIDStr.split(","));
            String dominantLayerID = properties.get(DOMINANT_LAYER_ATTR_NAME);
            RenderControl renderControl = RenderControl.getInstance();
            try {
                fromImage = renderControl.getLayerComposite(new ImageOutputID(fromImageName), layerIDList, dominantLayerID);
                toImage = renderControl.getLayerComposite(new ImageOutputID(toImageName), layerIDList, dominantLayerID);
            }
            catch (Exception e) {
                LOGGER.warn("Decode failed: " + e);
                return null;
            }
            String fromRampStr = properties.get(FROM_RAMP_ATTR_NAME);
            NumericalAlphaFunction fromRamp = fromRampStr == null ? null : NumericalAlphaFunction.createRamp(fromRampStr);
            String toRampStr = properties.get(TO_RAMP_ATTR_NAME);
            NumericalAlphaFunction toRamp = toRampStr == null ? null : NumericalAlphaFunction.createRamp(toRampStr);
            CrossMorph result = CrossMorph.newReferenceAlignmentInstance(id, fromImage, toImage, fromRamp, toRamp);
            String durationStr = properties.get(AS3Animation.DURATION_ATTR_NAME);
            if (durationStr != null) {
                result.setDurationInMillis(Long.valueOf(durationStr));
            }
            return result;
        }
    };
    private AS3Animation fromAnim;
    private AS3Animation toAnim;
    private Rectangle4d fromRectangle;
    private Rectangle4d toRectangle;
    private NumericalAlphaFunction fromAlphaFunction;
    private NumericalAlphaFunction toAlphaFunction;
    private boolean animationInitialized = false;
    private static final NumericalAlphaFunction STANDARD_FROM_RAMP = NumericalAlphaFunction.createRamp(0.6f, 0.8f);
    private static final NumericalAlphaFunction STANDARD_TO_RAMP = NumericalAlphaFunction.createRamp(0.0f, 0.6f);
    private static final NumericalAlphaFunction EARLY_RAMP = NumericalAlphaFunction.createRamp(0.0f, 0.4f);
    private static final NumericalAlphaFunction LATE_RAMP = NumericalAlphaFunction.createRamp(0.8f, 1.0f);
    private static final NumericalAlphaFunction END_RAMP = NumericalAlphaFunction.createRamp(1.0f, 1.0f);
    private static final NumericalAlphaFunction START_RAMP = NumericalAlphaFunction.createRamp(0.0f, 0.0f);
    private static final long MAX_PREF_DURATION = 1000L;
    private static final long MIN_PREF_DURATION = 500L;
    private static final Logger LOGGER = Logger.getLogger(CrossMorph.class);

    public static CrossMorph newFlatZoomInstance(String id, RenderImage fromImage, RenderImage toImage) {
        Rectangle4d fromRectangle;
        Rectangle4d toRectangle;
        if (fromImage != null && toImage != null) {
            Rectangle4d destBounds = toImage.getBoundsProportionalTo(fromImage);
            toRectangle = Card.CANONICAL_RECT;
            fromRectangle = destBounds;
        } else {
            fromRectangle = toRectangle = Card.CANONICAL_RECT;
        }
        boolean fromInFront = fromRectangle.getWidth() > toRectangle.getWidth();
        NumericalAlphaFunction fromAlphaFunction = fromInFront ? LATE_RAMP : END_RAMP;
        NumericalAlphaFunction toAlphaFunction = fromInFront ? START_RAMP : EARLY_RAMP;
        StillImage fromAnim = fromImage == null || fromImage.isEmpty() ? null : new StillImage(null, fromImage);
        StillImage toAnim = toImage == null || toImage.isEmpty() ? null : new StillImage(null, toImage);
        return new CrossMorph(id, fromAnim, toAnim, fromRectangle, toRectangle, fromAlphaFunction, toAlphaFunction);
    }

    public static CrossMorph newReferenceAlignmentInstance(String id, RenderImage fromImage, RenderImage toImage, NumericalAlphaFunction fromAlphaFunction, NumericalAlphaFunction toAlphaFunction) {
        Rectangle4d fromRectangle = null;
        if (fromImage != null) {
            fromRectangle = fromImage.getReferenceRectangle(true);
        }
        if (fromRectangle == null) {
            fromRectangle = Card.CANONICAL_RECT;
        }
        Rectangle4d toRectangle = null;
        if (toImage != null) {
            toRectangle = toImage.getReferenceRectangle(true);
        }
        if (toRectangle == null) {
            toRectangle = Card.CANONICAL_RECT;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Creating ref align. From = " + fromImage + ", to = " + toImage);
            LOGGER.debug("fromRect: " + fromRectangle + ", toRect: " + toRectangle);
        }
        StillImage fromAnim = fromImage == null || fromImage.isEmpty() ? null : new StillImage(null, fromImage);
        StillImage toAnim = toImage == null || toImage.isEmpty() ? null : new StillImage(null, toImage);
        return new CrossMorph(id, fromAnim, toAnim, fromRectangle, toRectangle, fromAlphaFunction, toAlphaFunction);
    }

    public static CrossMorph newTrackingInstance(String id, RenderImage fromImage, RenderImage toImage, CrossMorph tracked) {
        StillImage fromAnim = fromImage == null || fromImage.isEmpty() ? null : new StillImage(null, fromImage);
        StillImage toAnim = toImage == null || toImage.isEmpty() ? null : new StillImage(null, toImage);
        return new CrossMorph(id, fromAnim, toAnim, tracked.getFromRectangle(), tracked.getToRectangle(), tracked.getFromAlphaFunction(), tracked.getToAlphaFunction());
    }

    public CrossMorph(String id, AS3Animation fromAnim, AS3Animation toAnim, Rectangle4d fromRectangle, Rectangle4d toRectangle, NumericalAlphaFunction fromAlphaFunction, NumericalAlphaFunction toAlphaFunction) {
        super(id);
        this.fromAnim = fromAnim;
        this.toAnim = toAnim;
        this.fromRectangle = fromRectangle;
        this.toRectangle = toRectangle;
        this.fromAlphaFunction = fromAlphaFunction;
        this.toAlphaFunction = toAlphaFunction;
    }

    public Rectangle4d getFromRectangle() {
        return this.fromRectangle;
    }

    public Rectangle4d getToRectangle() {
        return this.toRectangle;
    }

    public NumericalAlphaFunction getFromAlphaFunction() {
        return this.fromAlphaFunction;
    }

    public NumericalAlphaFunction getToAlphaFunction() {
        return this.toAlphaFunction;
    }

    @Override
    public List<AS3Animation> splitByLayer(List<String> layerPatterns) {
        List<String> layerIDs;
        ArrayList<AS3Animation> result = new ArrayList<AS3Animation>();
        RenderImage fromImage = null;
        RenderImage toImage = null;
        if (this.fromAnim instanceof StillImage && this.toAnim instanceof StillImage) {
            fromImage = ((StillImage)this.fromAnim).getRenderedImage();
            toImage = ((StillImage)this.toAnim).getRenderedImage();
        }
        if (fromImage != null) {
            layerIDs = fromImage.getMatchingLayerIDs(layerPatterns);
        } else if (toImage != null) {
            layerIDs = toImage.getMatchingLayerIDs(layerPatterns);
        } else {
            return result;
        }
        for (String layerID : layerIDs) {
            RenderControl renderControl = RenderControl.getInstance();
            RenderImage splitFromImage = null;
            RenderImage splitToImage = null;
            try {
                splitFromImage = fromImage == null ? null : renderControl.getLayerImage(fromImage, layerID, RenderControl.DEFAULT_CONDITION);
                splitToImage = toImage == null ? null : renderControl.getLayerImage(toImage, layerID, RenderControl.DEFAULT_CONDITION);
            }
            catch (Exception e) {
                LOGGER.warn("Error loading images: ", e);
            }
            String splitID = this.getID() + "_" + layerID;
            CrossMorph splitMorph = CrossMorph.newReferenceAlignmentInstance(splitID, splitFromImage, splitToImage, this.fromAlphaFunction, this.toAlphaFunction);
            splitMorph.setDurationInMillis(this.getDurationInMillis());
            result.add(splitMorph);
        }
        return result;
    }

    @Override
    public String toAS3String(TemplateLibrary templates) throws ParseException {
        this.initAnimation();
        return super.toAS3String(templates);
    }

    @Override
    public Set<RenderImage> getImages(boolean renderableOnly) {
        this.initAnimation();
        return super.getImages(renderableOnly);
    }

    private void initAnimation() {
        List<MultiPropertyKeyframes> componentKeyframes;
        List<AS3Animation> layerAnimations;
        NumericalAlphaFunction rampFunc;
        if (this.animationInitialized) {
            return;
        }
        Rectangle4d fromRectImage = Card.CARD_RECT.fromProportional(this.fromRectangle);
        Rectangle4d toRectImage = Card.CARD_RECT.fromProportional(this.toRectangle);
        boolean fromInFront = this.fromRectangle.getWidth() > this.toRectangle.getWidth();
        MultiPropertyKeyframes fromKeyframes = null;
        MultiPropertyKeyframes toKeyframes = null;
        if (this.fromAnim != null) {
            fromKeyframes = AnimationUtils.getMorphKeyframes(fromRectImage, fromRectImage, toRectImage);
            fromKeyframes.addKeyframe(AnimationUtils.ALPHA_PROPERTY, Float.valueOf(0.0f), Float.valueOf(1.0f));
            fromKeyframes.addKeyframe(AnimationUtils.ALPHA_PROPERTY, Float.valueOf(1.0f), Float.valueOf(0.0f));
            rampFunc = this.fromAlphaFunction == null ? this.chooseFromAlphaFunction() : this.fromAlphaFunction;
            fromKeyframes.getKeyframes(AnimationUtils.ALPHA_PROPERTY).applyAlphaFunc(rampFunc, 1);
        }
        if (this.toAnim != null) {
            toKeyframes = AnimationUtils.getMorphKeyframes(toRectImage, fromRectImage, toRectImage);
            toKeyframes.addKeyframe(AnimationUtils.ALPHA_PROPERTY, Float.valueOf(0.0f), Float.valueOf(0.0f));
            toKeyframes.addKeyframe(AnimationUtils.ALPHA_PROPERTY, Float.valueOf(1.0f), Float.valueOf(1.0f));
            rampFunc = this.toAlphaFunction == null ? this.chooseToAlphaFunction() : this.toAlphaFunction;
            toKeyframes.getKeyframes(AnimationUtils.ALPHA_PROPERTY).applyAlphaFunc(rampFunc, 1);
        }
        if (fromInFront) {
            layerAnimations = CollectionUtils.asListIgnoreNulls(this.toAnim, this.fromAnim);
            componentKeyframes = CollectionUtils.asListIgnoreNulls(toKeyframes, fromKeyframes);
        } else {
            layerAnimations = CollectionUtils.asListIgnoreNulls(this.fromAnim, this.toAnim);
            componentKeyframes = CollectionUtils.asListIgnoreNulls(fromKeyframes, toKeyframes);
        }
        this.setComponentAnimations(layerAnimations);
        this.setComponentKeyframes(componentKeyframes);
        this.setDurationInMillis(this.getPreferredDuration());
        this.animationInitialized = true;
    }

    public long getPreferredDuration() {
        double ratio = this.fromRectangle.getWidth() / this.toRectangle.getWidth();
        if (ratio > 1.0) {
            ratio = 1.0 / ratio;
        }
        return Math.max(500L, (long)(1000.0 * (1.0 - ratio)));
    }

    private NumericalAlphaFunction chooseFromAlphaFunction() {
        if (this.toAnim == null) {
            return END_RAMP;
        }
        return STANDARD_FROM_RAMP;
    }

    private NumericalAlphaFunction chooseToAlphaFunction() {
        if (this.fromAnim == null) {
            return START_RAMP;
        }
        return STANDARD_TO_RAMP;
    }
}

