/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.animation.AlphaFunction;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.util.StringTemplate;
import java.text.ParseException;
import java.util.List;

public class CompoundAlphaFunction
extends AlphaFunction {
    private final List<AlphaFunction> subFunctions;

    public CompoundAlphaFunction(List<AlphaFunction> subFunctions) {
        this.subFunctions = subFunctions;
    }

    @Override
    public String toAS3String(TemplateLibrary templates) throws ParseException {
        StringTemplate template = templates.getTemplate(this.getClass());
        assert (template != null) : "Missing template: " + this.getClass();
        StringBuilder subFuncList = new StringBuilder();
        for (AlphaFunction func : this.subFunctions) {
            if (subFuncList.length() > 0) {
                subFuncList.append(",");
            }
            subFuncList.append(func.toAS3String(templates));
        }
        template.setParameterValue("SUB_FUNCTIONS", subFuncList.toString());
        return template.getProcessedText();
    }
}

