/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.animation.AS3Animation;
import com.sodiumarc.patchwork.animation.AnimationGenerator;
import com.sodiumarc.patchwork.animation.AnimationInstance;
import com.sodiumarc.patchwork.animation.AnimationSequencer;
import com.sodiumarc.patchwork.animation.CompoundAnimation;
import com.sodiumarc.patchwork.animation.KeyframesInstance;
import com.sodiumarc.patchwork.animation.MultiPropertyKeyframes;
import com.sodiumarc.patchwork.animation.NumericalAlphaFunction;
import com.sodiumarc.patchwork.animation.ScriptedSequencer;
import com.sodiumarc.patchwork.util.Collection.CollectionUtils;
import com.sodiumarc.patchwork.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class ChainAnimation
extends AnimationGenerator {
    public static final String PARAM_ANIM_IDS = "animIDs";
    public static final String PARAM_KF_ID = "kfID";
    public static final String PARAM_VISIBLE_LINKS = "visibleLinks";
    public static final String PARAM_LOOP_COUNT = "loopCount";

    @Override
    protected Set<String> getRequiredParameters() {
        return CollectionUtils.asHashSetIgnoreNulls(PARAM_ANIM_IDS, PARAM_KF_ID);
    }

    @Override
    public AS3Animation createAnimation(String id, long duration, Properties parameters) {
        int totalLinks;
        CompoundAnimation result = new CompoundAnimation(id, duration);
        String[] animIDs = StringUtils.decodeStringArray(parameters.getProperty(PARAM_ANIM_IDS), ",");
        String kfID = parameters.getProperty(PARAM_KF_ID);
        int visibleLinks = totalLinks = animIDs.length;
        if (parameters.containsKey(PARAM_VISIBLE_LINKS)) {
            visibleLinks = Integer.valueOf(parameters.getProperty(PARAM_VISIBLE_LINKS));
        }
        int loopCount = 1;
        if (parameters.containsKey(PARAM_LOOP_COUNT)) {
            loopCount = Integer.valueOf(parameters.getProperty(PARAM_LOOP_COUNT));
        }
        List<AS3Animation> linkAnimations = this.createLinkAnimations(kfID, animIDs, id + "-link");
        result.setComponentAnimations(linkAnimations);
        result.setSequencer(this.createSequencer(totalLinks, visibleLinks));
        if (loopCount > 1) {
            NumericalAlphaFunction loopFunction = new NumericalAlphaFunction();
            loopFunction.setLoops(loopCount);
            result.setAlphaFunction(loopFunction);
        }
        return result;
    }

    private List<AS3Animation> createLinkAnimations(String kfID, String[] animIDs, String idBase) {
        ArrayList<AS3Animation> result = new ArrayList<AS3Animation>();
        int animIndex = 0;
        for (String animID : animIDs) {
            CompoundAnimation linkAnimation = new CompoundAnimation(idBase + animIndex);
            linkAnimation.setContainerKeyframes(new KeyframesInstance(kfID));
            linkAnimation.setComponentAnimations(Collections.singletonList(new AnimationInstance(null, animID.trim())));
            result.add(linkAnimation);
            ++animIndex;
        }
        return result;
    }

    private AnimationSequencer createSequencer(int totalLinks, int visibleLinks) {
        ArrayList<MultiPropertyKeyframes> keyframesByAnimIndex = new ArrayList<MultiPropertyKeyframes>();
        for (int i = 0; i < totalLinks; ++i) {
            keyframesByAnimIndex.add(this.createKeyframes(totalLinks, visibleLinks, i));
        }
        return new ScriptedSequencer(keyframesByAnimIndex);
    }

    private MultiPropertyKeyframes createKeyframes(int totalLinks, int visibleLinks, int linkIndex) {
        float visibleStart;
        MultiPropertyKeyframes result = new MultiPropertyKeyframes(null);
        float visibleEnd = totalLinks == visibleLinks ? visibleStart : (visibleStart + (float)visibleLinks / (float)totalLinks) % 1.0f;
        if (visibleEnd <= (visibleStart = (float)linkIndex / (float)totalLinks)) {
            float boundaryVal = 1.0f - visibleEnd;
            if (visibleEnd > 0.0f) {
                this.addKeyframe(0.0f, boundaryVal, linkIndex, result);
                this.addKeyframe(visibleEnd, 1.0f, linkIndex, result);
            }
            if (visibleStart != visibleEnd) {
                this.addKeyframe(visibleEnd, 0.0f, -1.0f, result);
                this.addKeyframe(visibleStart, 0.0f, -1.0f, result);
            }
            this.addKeyframe(visibleStart, 0.0f, linkIndex, result);
            this.addKeyframe(1.0f, boundaryVal, linkIndex, result);
        } else {
            if (visibleStart > 0.0f) {
                this.addKeyframe(0.0f, 0.0f, -1.0f, result);
                this.addKeyframe(visibleStart, 0.0f, -1.0f, result);
            }
            this.addKeyframe(visibleStart, 0.0f, linkIndex, result);
            this.addKeyframe(visibleEnd, 1.0f, linkIndex, result);
            if (visibleStart < 1.0f) {
                this.addKeyframe(visibleEnd, 0.0f, -1.0f, result);
                this.addKeyframe(1.0f, 0.0f, -1.0f, result);
            }
        }
        return result;
    }

    private void addKeyframe(float time, float elapsedCycles, float layerIndex, MultiPropertyKeyframes keyframes) {
        keyframes.addKeyframe(ScriptedSequencer.ELAPSED_CYCLES_PROPERTY, Float.valueOf(time), Float.valueOf(elapsedCycles));
        keyframes.addKeyframe(ScriptedSequencer.LAYER_INDEX_PROPERTY, Float.valueOf(time), Float.valueOf(layerIndex));
    }
}

