/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.app.scenecomposer.as3.AS3Convertible;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.util.StringTemplate;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.text.ParseException;
import java.util.Map;
import org.w3c.dom.Node;

public class AnimationMask
implements AS3Convertible {
    public static String ELEMENT_NAME = "mask";
    public static String TARGET_ID_NAME = "target_id";
    public static String MASK_ID_NAME = "mask_id";
    public static DocumentNodeDecoder<AnimationMask> DECODER = new DocumentNodeDecoder<AnimationMask>(){

        @Override
        public AnimationMask decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            return new AnimationMask(attributes.get(TARGET_ID_NAME), attributes.get(MASK_ID_NAME));
        }
    };
    private final String targetAnimationID;
    private final String maskAnimationID;

    public AnimationMask(String targetAnimationID, String maskAnimationID) {
        this.targetAnimationID = targetAnimationID;
        this.maskAnimationID = maskAnimationID;
    }

    @Override
    public String toAS3String(TemplateLibrary templates) throws ParseException {
        StringTemplate template = templates.getTemplate(this.getClass());
        assert (template != null) : "Missing template: " + this.getClass();
        template.setParameterValue("TARGET_ID", this.targetAnimationID);
        template.setParameterValue("MASK_ID", this.maskAnimationID);
        return template.getProcessedText();
    }
}

