/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.animation.AS3Animation;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public abstract class AnimationGenerator {
    static String ELEMENT_NAME = "gen_anim";
    static String ID_ATTR_NAME = "id";
    static String DURATION_ATTR_NAME = "duration";
    static String CLASS_ATTR_NAME = "class";
    public static DocumentNodeDecoder<AS3Animation> DECODER = new DocumentNodeDecoder<AS3Animation>(){

        @Override
        public AS3Animation decode(Node node) {
            Object generatorObj;
            Class<?> generatorClass;
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> attributes = XMLUtils.getAttributes(node);
            try {
                String className = attributes.get(CLASS_ATTR_NAME);
                String packageName = AnimationGenerator.class.getPackage().getName();
                generatorClass = Class.forName(packageName + "." + className);
                generatorObj = generatorClass.newInstance();
            }
            catch (Exception e) {
                Logger.getLogger(AnimationGenerator.class).warn("Decode failed: ", e);
                return null;
            }
            assert (generatorObj instanceof AnimationGenerator) : "Invalid generator type: " + generatorClass;
            AnimationGenerator generator = (AnimationGenerator)generatorObj;
            Properties paramaters = XMLUtils.childrenAsProperties(node, "name", "value");
            for (String requiredParam : generator.getRequiredParameters()) {
                if (paramaters.containsKey(requiredParam)) continue;
                Logger.getLogger(AnimationGenerator.class).warn("Missing parameter: " + requiredParam);
                return null;
            }
            return generator.createAnimation(attributes.get(ID_ATTR_NAME), AS3Animation.decodeDuration(attributes.get(DURATION_ATTR_NAME)), paramaters);
        }
    };

    protected abstract AS3Animation createAnimation(String var1, long var2, Properties var4);

    protected Set<String> getRequiredParameters() {
        return Collections.EMPTY_SET;
    }
}

