/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.animation.AlphaFunction;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.util.Collection.Range;
import com.sodiumarc.patchwork.util.StringTemplate;
import java.text.ParseException;

public class AdjustableRampFunction
extends AlphaFunction {
    public static String SEPARATOR = ",";
    private final Range<Double> ramp;

    public AdjustableRampFunction(double rampStart, double rampEnd) {
        this(new Range<Double>(rampStart, rampEnd));
    }

    public AdjustableRampFunction(Range<Double> ramp) {
        this.ramp = ramp;
    }

    public AdjustableRampFunction(String encodedForm) {
        String[] components = encodedForm.split(SEPARATOR);
        assert (components.length == 2) : "Wrong number of components: " + components.length;
        this.ramp = new Range<Double>(Double.valueOf(components[0]), Double.valueOf(components[1]));
    }

    public Range<Double> getRamp() {
        return this.ramp;
    }

    @Override
    public String toAS3String(TemplateLibrary templates) throws ParseException {
        StringTemplate template = templates.getTemplate(this.getClass());
        assert (template != null) : "Missing template: " + this.getClass();
        template.setParameterValue((Object)"ALPHA_RAMP_START", this.ramp.getMin());
        template.setParameterValue((Object)"ALPHA_RAMP_END", this.ramp.getMax());
        return template.getProcessedText();
    }
}

