/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.animation.InterpolationFunction;
import com.sodiumarc.patchwork.util.MathUtils;

public class AccelerationInterpFunction
implements InterpolationFunction {
    private final float[] positions = new float[100];
    private static final int TIME_STEPS = 100;

    public AccelerationInterpFunction(float accelFraction, float decelFraction, float force) {
        int i;
        float velocity = 0.0f;
        float minPosition = 0.0f;
        float maxPosition = 0.0f;
        for (i = 1; i < 100; ++i) {
            float position;
            float elapsedFraction = (float)i / 100.0f;
            float acceleration = 0.0f;
            if (elapsedFraction <= accelFraction) {
                acceleration = force;
            } else if (elapsedFraction >= 1.0f - decelFraction) {
                acceleration = -force;
            }
            this.positions[i] = position = this.positions[i - 1] + (velocity += acceleration);
            minPosition = Math.min(minPosition, position);
            maxPosition = Math.max(maxPosition, position);
        }
        for (i = 0; i < 100; ++i) {
            this.positions[i] = (float)MathUtils.rangeFraction(this.positions[i], minPosition, maxPosition);
        }
    }

    @Override
    public float getInterpFraction(float inputFraction) {
        int index = (int)(inputFraction * 99.0f);
        return this.positions[MathUtils.clamp(index, 0, 99)];
    }
}

