/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork.animation;

import com.sodiumarc.patchwork.animation.AlphaFunction;
import com.sodiumarc.patchwork.animation.AnimationGenerator;
import com.sodiumarc.patchwork.animation.AnimationInstance;
import com.sodiumarc.patchwork.animation.CompoundAnimation;
import com.sodiumarc.patchwork.animation.CrossMorph;
import com.sodiumarc.patchwork.animation.ImportedAnimation;
import com.sodiumarc.patchwork.animation.MoveTransition;
import com.sodiumarc.patchwork.animation.SplitAnimation;
import com.sodiumarc.patchwork.animation.StillImage;
import com.sodiumarc.patchwork.app.scenecomposer.as3.AS3Convertible;
import com.sodiumarc.patchwork.app.scenecomposer.as3.TemplateLibrary;
import com.sodiumarc.patchwork.render.control.RenderImage;
import com.sodiumarc.patchwork.util.xml.DocumentNodeDecoder;
import com.sodiumarc.patchwork.util.xml.XMLUtils;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public abstract class AS3Animation
implements AS3Convertible {
    public static String ELEMENT_NAME = "animation";
    public static String ID_ATTR_NAME = "id";
    public static String DURATION_ATTR_NAME = "duration";
    public static DocumentNodeDecoder<AS3Animation> DECODER = new DocumentNodeDecoder<AS3Animation>(){

        @Override
        public AS3Animation decode(Node node) {
            assert (node != null) : "Null node";
            if (!node.getLocalName().equals(ELEMENT_NAME)) {
                return null;
            }
            Map<String, String> properties = XMLUtils.getAttributes(node);
            String id = properties.get(ID_ATTR_NAME);
            long durationInMillis = AS3Animation.decodeDuration(properties.get(DURATION_ATTR_NAME));
            List<AS3Animation> animations = XMLUtils.decodeChildren(node, AS3Animation.getSubclassDecoders());
            for (AS3Animation animation : animations) {
                animation.setID(id);
                animation.setDurationInMillis(durationInMillis);
            }
            if (animations.size() == 1) {
                return animations.get(0);
            }
            if (animations.size() > 1) {
                CompoundAnimation result = new CompoundAnimation(id);
                result.setComponentAnimations(animations);
            }
            return null;
        }
    };
    private String id;
    private long durationInMillis;
    private AlphaFunction alphaFunction;
    private static Set<DocumentNodeDecoder<? extends AS3Animation>> SUBCLASS_DECODERS = new HashSet<DocumentNodeDecoder<? extends AS3Animation>>();

    public static long decodeDuration(String durationStr) {
        if (durationStr == null) {
            return -1L;
        }
        if (durationStr.equals("Infinity")) {
            return Long.MAX_VALUE;
        }
        return Long.valueOf(durationStr);
    }

    public static final Set<DocumentNodeDecoder<? extends AS3Animation>> getSubclassDecoders() {
        return Collections.unmodifiableSet(SUBCLASS_DECODERS);
    }

    public AS3Animation(Map<String, String> properties) {
        this(properties.get(ID_ATTR_NAME));
        this.durationInMillis = AS3Animation.decodeDuration(properties.get(DURATION_ATTR_NAME));
    }

    public AS3Animation(String id, long durationInMillis) {
        this.id = id;
        this.durationInMillis = durationInMillis;
    }

    public AS3Animation(String id) {
        this(id, -1L);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public long getDurationInMillis() {
        return this.durationInMillis;
    }

    public void setDurationInMillis(long durationInMillis) {
        this.durationInMillis = durationInMillis;
    }

    public AlphaFunction getAlphaFunction() {
        return this.alphaFunction;
    }

    public void setAlphaFunction(AlphaFunction alphaFunction) {
        this.alphaFunction = alphaFunction;
    }

    public abstract Set<RenderImage> getImages(boolean var1);

    protected final String durationAsAS3String() {
        return this.durationInMillis == Long.MAX_VALUE ? "Infinity" : Long.toString(this.durationInMillis);
    }

    public final String alphaFunctionAsAS3String(TemplateLibrary templates) throws ParseException {
        return this.alphaFunction == null ? null : this.alphaFunction.toAS3String(templates);
    }

    static {
        SUBCLASS_DECODERS.add(AnimationInstance.DECODER);
        SUBCLASS_DECODERS.add(CrossMorph.DECODER);
        SUBCLASS_DECODERS.add(CompoundAnimation.DECODER);
        SUBCLASS_DECODERS.add(SplitAnimation.DECODER);
        SUBCLASS_DECODERS.add(StillImage.DECODER);
        SUBCLASS_DECODERS.add(MoveTransition.DECODER);
        SUBCLASS_DECODERS.add(ImportedAnimation.DECODER);
        SUBCLASS_DECODERS.add(AnimationGenerator.DECODER);
    }
}

