/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork;

import com.sodiumarc.patchwork.collada.Animation;
import com.sodiumarc.patchwork.collada.COLLADA;
import com.sodiumarc.patchwork.collada.Channel;
import com.sodiumarc.patchwork.collada.GeometricTransformElement;
import com.sodiumarc.patchwork.collada.Geometry;
import com.sodiumarc.patchwork.collada.Mesh;
import com.sodiumarc.patchwork.collada.Node;
import com.sodiumarc.patchwork.collada.Polygons;
import com.sodiumarc.patchwork.collada.Rotate;
import com.sodiumarc.patchwork.collada.Scale;
import com.sodiumarc.patchwork.collada.Translate;
import com.sodiumarc.patchwork.collada.VisualScene;
import com.sodiumarc.patchwork.util.MathUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class GeomResourceWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, COLLADA root, String packageName) throws IOException {
        String className = file.getName().substring(0, file.getName().lastIndexOf(46));
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(fileOutputStream);
            this.writeClass(printWriter, packageName + "." + className, root.getGeometries(), root.getAnimations(), root.getVisualScenes());
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private void writeClass(PrintWriter printWriter, String name, List<Geometry> geometries, List<Animation> animations, List<VisualScene> scenes) {
        printWriter.println("import com.sodiumarc.simple3d.*;");
        printWriter.println("import com.sodiumarc.animation.*;");
        printWriter.println("class " + name + " {");
        this.writeGetRootMethod(printWriter, scenes);
        this.writeGetAnimatorMethod(printWriter, animations);
        this.writeMeshSelectorMethod(printWriter, geometries);
        int index = 0;
        for (Geometry geom : geometries) {
            this.writeMeshFactoryMethod(printWriter, geom, index);
            this.writeVerticesMethod(printWriter, geom, index);
            this.writeNormalsMethod(printWriter, geom, index);
            ++index;
        }
        printWriter.println("}");
    }

    private void writeGetRootMethod(PrintWriter printWriter, List<VisualScene> scenes) {
        printWriter.println("public static function getRoot():SceneGraphBranch {");
        for (VisualScene scene : scenes) {
            String rootName = "root";
            printWriter.println("var " + rootName + ":SceneGraphBranch = new SceneGraphBranch(\"" + scene.getName() + "\")");
            List<Node> roots = scene.getRootNodes();
            int rootIndex = 0;
            for (Node root : roots) {
                this.writeNode(printWriter, root, rootName, 0, rootIndex++);
            }
        }
        printWriter.println("return root;");
        printWriter.println("}");
    }

    private void writeNode(PrintWriter printWriter, Node node, String parentName, int generation, int index) {
        if (!node.subtreeContainsGeometry()) {
            return;
        }
        String nodeName = node.getId();
        String baseNodeVarName = "node_" + nodeName;
        printWriter.println();
        printWriter.println("var " + baseNodeVarName + ":SceneGraphBranch = new SceneGraphBranch(\"" + nodeName + "\")");
        printWriter.println(parentName + ".addChild(" + baseNodeVarName + ");");
        String nodeVarName = baseNodeVarName;
        nodeVarName = this.writeTransformSubNode(printWriter, node, nodeVarName, node.getTranslate());
        nodeVarName = this.writeTransformSubNode(printWriter, node, nodeVarName, node.getRotate("rotateZ"));
        nodeVarName = this.writeTransformSubNode(printWriter, node, nodeVarName, node.getRotate("rotateY"));
        nodeVarName = this.writeTransformSubNode(printWriter, node, nodeVarName, node.getRotate("rotateX"));
        nodeVarName = this.writeTransformSubNode(printWriter, node, nodeVarName, node.getScale());
        List<Node> children = node.getChildNodes();
        int childIndex = 0;
        for (Node child : children) {
            this.writeNode(printWriter, child, nodeVarName, generation + 1, childIndex++);
        }
        List<String> geomIds = node.getGeometryIds();
        for (String id : geomIds) {
            printWriter.println(nodeVarName + ".addChild(getMesh(\"" + id + "\", null));");
        }
    }

    private String writeTransformSubNode(PrintWriter printWriter, Node baseNode, String parentNodeName, GeometricTransformElement element) {
        if (element == null || element.isNoOp()) {
            return parentNodeName;
        }
        List<Float> values = element.getValues();
        String nodeName = this.getTransformSubNodeName(baseNode.getId(), element.getSid());
        String newNodeVarName = "node_" + nodeName;
        printWriter.println();
        printWriter.println("var " + newNodeVarName + ":SceneGraphBranch = new SceneGraphBranch(\"" + nodeName + "\")");
        printWriter.println(parentNodeName + ".addChild(" + newNodeVarName + ");");
        String xfName = newNodeVarName + "XF";
        printWriter.println("var " + xfName + ":Transform3D = new Transform3D();");
        printWriter.println(newNodeVarName + ".setTransform(" + xfName + ");");
        if (element instanceof Translate) {
            printWriter.println(xfName + ".setTranslation(" + values.get(0) + "," + values.get(1) + "," + values.get(2) + ");");
        } else if (element instanceof Scale) {
            printWriter.println(xfName + ".setScale(" + values.get(0) + "," + values.get(1) + "," + values.get(2) + ");");
        } else if (element instanceof Rotate) {
            printWriter.println(xfName + ".setRotation(new Vector3D(" + values.get(0) + "," + values.get(1) + "," + values.get(2) + ")," + MathUtils.degreesToRadians(values.get(3).floatValue()) + ");");
        }
        return newNodeVarName;
    }

    private void writeMeshSelectorMethod(PrintWriter printWriter, List<Geometry> geometries) {
        printWriter.println("public static function getMesh(meshName:String, appearance:Appearance):PolyMesh3D {");
        int index = 0;
        for (Geometry geom : geometries) {
            printWriter.println("if (meshName == \"" + geom.getName() + "\") {");
            printWriter.println("return getMesh" + index++ + "(appearance);");
            printWriter.println("}");
        }
        printWriter.println("return null;");
        printWriter.println("}");
    }

    private void writeMeshFactoryMethod(PrintWriter printWriter, Geometry geometry, int index) {
        String meshName = geometry.getName();
        printWriter.println("public static function getMesh" + index + "(appearance:Appearance):PolyMesh3D {");
        printWriter.println("var mesh:PolyMesh3D = new PolyMesh3D(\"" + meshName + "\", appearance);");
        printWriter.println("mesh.setVertices(getVertices" + index + "());");
        printWriter.println("mesh.setNormals(getNormals" + index + "());");
        Mesh mesh = geometry.getMesh();
        this.writePolygons(printWriter, mesh);
        printWriter.println("return mesh;");
        printWriter.println("}");
    }

    private void writeVerticesMethod(PrintWriter printWriter, Geometry geometry, int index) {
        printWriter.println("public static function getVertices" + index + "():Array {");
        Mesh mesh = geometry.getMesh();
        List<Float> vertexValues = mesh.getVertexValues();
        StringBuffer verticesArrayString = new StringBuffer();
        for (int i = 0; i < vertexValues.size(); i += 3) {
            if (verticesArrayString.length() > 0) {
                verticesArrayString.append(",");
            }
            verticesArrayString.append("new Vertex3D(" + vertexValues.get(i) + "," + vertexValues.get(i + 1) + "," + vertexValues.get(i + 2) + ")");
        }
        printWriter.println("return new Array(" + verticesArrayString + ");");
        printWriter.println("}");
    }

    private void writeNormalsMethod(PrintWriter printWriter, Geometry geometry, int index) {
        printWriter.println("public static function getNormals" + index + "():Array {");
        Mesh mesh = geometry.getMesh();
        List<Polygons> polygonsList = mesh.getPolygons();
        StringBuffer normalsArrayString = new StringBuffer();
        for (Polygons polygons : polygonsList) {
            String normalSourceId = polygons.getInputForSemantic("NORMAL").getSourceId();
            List<Float> normalValues = mesh.getSourceArray(normalSourceId);
            List<List<Integer>> indexLists = polygons.getIndexLists();
            int indexStride = polygons.getMaxInputOffset() + 1;
            int normalOffset = polygons.getInputForSemantic("NORMAL").getOffset();
            int normalIndex = -1;
            for (List<Integer> indexList : indexLists) {
                int offset = 0;
                for (Integer i : indexList) {
                    if (offset == normalOffset) {
                        normalIndex = i;
                    }
                    offset = (offset + 1) % indexStride;
                }
                if (normalsArrayString.length() > 0) {
                    normalsArrayString.append(",");
                }
                normalsArrayString.append("new Vector3D(" + normalValues.get(3 * normalIndex) + "," + normalValues.get(3 * normalIndex + 1) + "," + normalValues.get(3 * normalIndex + 2) + ")");
            }
        }
        printWriter.println("return new Array(" + normalsArrayString + ");");
        printWriter.println("}");
    }

    private void writePolygons(PrintWriter printWriter, Mesh mesh) {
        List<Polygons> polygonsList = mesh.getPolygons();
        int polygonIndex = 0;
        for (Polygons polygons : polygonsList) {
            List<List<Integer>> indexLists = polygons.getIndexLists();
            int indexStride = polygons.getMaxInputOffset() + 1;
            int vertexOffset = polygons.getInputForSemantic("VERTEX").getOffset();
            for (List<Integer> indexList : indexLists) {
                StringBuffer indexListString = new StringBuffer();
                int offset = 0;
                for (Integer index : indexList) {
                    if (offset == vertexOffset) {
                        if (indexListString.length() > 0) {
                            indexListString.append(",");
                        }
                        indexListString.append(index);
                    }
                    offset = (offset + 1) % indexStride;
                }
                printWriter.println("mesh.addPolygon(new Array(" + indexListString + ")," + polygonIndex++ + ");");
            }
        }
    }

    private void writeGetAnimatorMethod(PrintWriter printWriter, List<Animation> animations) {
        printWriter.println("public static function getAnimators(root:SceneGraphBranch):Animator {");
        printWriter.println("var animationTarget:SceneGraphBranch = null;");
        printWriter.println("var rootAnimator:CompositeAnimator = new CompositeAnimator();");
        float minInputValue = -1.0f;
        float maxInputValue = -1.0f;
        for (Animation animation : animations) {
            List<Channel> channels = animation.getChannels();
            for (Channel channel : channels) {
                String nodeId = channel.getTargetNodeId();
                String samplerId = channel.getSamplerId();
                String transformSid = channel.getTargetTransformSid();
                String targetNodeName = this.getTransformSubNodeName(nodeId, transformSid);
                printWriter.println();
                printWriter.println("animationTarget = SceneGraphBranch(root.getTransformable(\"" + targetNodeName + "\"));");
                String animatorName = "anim_" + targetNodeName;
                boolean convertDegreesToRadians = false;
                if ("translate".equals(transformSid)) {
                    printWriter.println("var " + animatorName + ":TranslationAnimator = new TranslationAnimator(" + "animationTarget.getTransform());");
                } else if ("rotateX".equals(transformSid)) {
                    printWriter.println("var " + animatorName + ":RotationAnimator = new RotationAnimator(" + "animationTarget.getTransform(),new Vector3D(1,0,0));");
                    convertDegreesToRadians = true;
                } else if ("rotateY".equals(transformSid)) {
                    printWriter.println("var " + animatorName + ":RotationAnimator = new RotationAnimator(" + "animationTarget.getTransform(),new Vector3D(0,1,0));");
                    convertDegreesToRadians = true;
                } else if ("rotateZ".equals(transformSid)) {
                    printWriter.println("var " + animatorName + ":RotationAnimator = new RotationAnimator(" + "animationTarget.getTransform(),new Vector3D(0,0,1));");
                    convertDegreesToRadians = true;
                } else if ("scale".equals(transformSid)) {
                    printWriter.println("var " + animatorName + ":ScaleAnimator = new ScaleAnimator(" + "animationTarget.getTransform(),new Vector3D(0,0,1));");
                }
                List<Float> inputs = animation.getInputValues(samplerId);
                List<Float> outputs = animation.getOutputValues(samplerId);
                for (int i = 0; i < inputs.size(); ++i) {
                    float inputValue = inputs.get(i).floatValue();
                    if (maxInputValue == -1.0f || inputValue > maxInputValue) {
                        maxInputValue = inputValue;
                    }
                    if (minInputValue == -1.0f || inputValue < minInputValue) {
                        minInputValue = inputValue;
                    }
                    float outputValue = convertDegreesToRadians ? (float)MathUtils.degreesToRadians(outputs.get(i).floatValue()) : outputs.get(i).floatValue();
                    printWriter.println(animatorName + ".addKeyFrame(" + inputValue + ", " + outputValue + ")");
                }
                printWriter.println("rootAnimator.addComponentAnimator(" + animatorName + ");");
            }
        }
        int durationInMillis = (int)((maxInputValue - minInputValue) * 1000.0f);
        printWriter.println();
        printWriter.println("rootAnimator.setDurationInMillis(" + durationInMillis + ");");
        printWriter.println("return rootAnimator;");
        printWriter.println("}");
    }

    private String getTransformSubNodeName(String nodeId, String transformSid) {
        return nodeId + "_" + transformSid;
    }
}

