/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Arrays;
import java.util.List;

public class FileUtils {
    public static final FilenameFilter DAE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".dae");
        }
    };
    public static final FilenameFilter JPG_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jpg");
        }
    };

    public static List<String> getAllFilenames(File directory, final String extension) {
        String[] list = directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return FileUtils.hasFileExtension(name, extension);
            }
        });
        return Arrays.asList(list);
    }

    public static String appendBeforeExtension(String filename, String stringToAppend) {
        String filenameWithoutExtension = FileUtils.getFilenameWithoutExtension(filename);
        String extension = FileUtils.getFileExtension(filename);
        return filenameWithoutExtension + stringToAppend + "." + extension;
    }

    public static String getFilenameWithoutExtension(String filename) {
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex < 0) {
            return filename;
        }
        return filename.substring(0, dotIndex);
    }

    public static File canonicalOrAbsolute(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }

    public static String replaceExtension(String filename, String extension) {
        return FileUtils.addExtension(FileUtils.getFilenameWithoutExtension(filename), extension);
    }

    public static String addExtension(String filename, String extension) {
        return filename + "." + extension;
    }

    public static String ensureExtension(String filename, String extension) {
        if (FileUtils.hasFileExtension(filename, extension)) {
            return filename;
        }
        return FileUtils.addExtension(filename, extension);
    }

    public static String getFileExtension(String filename) {
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex < 0) {
            return "";
        }
        return filename.substring(dotIndex + 1);
    }

    public static boolean hasFileExtension(String filename, String extension) {
        String fileExtension = FileUtils.getFileExtension(filename);
        return fileExtension.equalsIgnoreCase(extension);
    }

    public static void writeString(String string, File file) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(string);
        writer.close();
    }

    public static void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyNIO(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }
}

