/*
 * Decompiled with CFR 0.152.
 */
package com.sodiumarc.patchwork;

import com.sodiumarc.patchwork.FileUtils;
import com.sodiumarc.patchwork.GeomResourceWriter;
import com.sodiumarc.patchwork.collada.ColladaSAXHandler;
import com.sodiumarc.patchwork.util.AppUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Collada2ActionScript {
    public static void main(String[] args) {
        try {
            if (args.length != 3) {
                AppUtils.die("bad args");
            }
            File inputPath = new File(args[0]);
            File outputPath = new File(args[1]);
            String packageName = args[2];
            if (!outputPath.isDirectory()) {
                AppUtils.die("invalid output dir");
            }
            File[] inputFiles = null;
            inputFiles = inputPath.isDirectory() ? inputPath.listFiles(FileUtils.DAE_FILTER) : new File[]{inputPath};
            Collada2ActionScript c2a = new Collada2ActionScript();
            for (int i = 0; i < inputFiles.length; ++i) {
                c2a.load(inputFiles[i], outputPath, packageName);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void load(File inputFile, File outputDir, String packageName) throws SAXException, IOException, ParserConfigurationException {
        FileInputStream fileInputStream = new FileInputStream(inputFile);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        SAXParser saxParser = factory.newSAXParser();
        ColladaSAXHandler colladaSAXHandler = new ColladaSAXHandler();
        saxParser.parse(new InputSource(fileInputStream), (DefaultHandler)colladaSAXHandler);
        GeomResourceWriter actionScriptWriter = new GeomResourceWriter();
        String inputFilename = inputFile.getName();
        String outputFilename = inputFilename.substring(0, inputFilename.lastIndexOf(46)) + ".as";
        System.out.println(inputFilename + " -> " + outputFilename);
        actionScriptWriter.write(new File(outputDir, outputFilename), colladaSAXHandler.getRoot(), packageName);
    }
}

